/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.FileUtils;
import com.hummer.im.model.chat.Content;
import java.io.File;
import java.util.Locale;
import org.json.JSONObject;

public class Image
extends Content {
    public static final int TYPE = 1;
    private final int width;
    private final int height;
    private final String originUrl;
    private String thumbUrl;
    private static final String TAG = "Image";

    private Image(String path, int width, int height) {
        this.originUrl = path;
        this.width = width;
        this.height = height;
    }

    public static Image create(@NonNull String path, int width, int height) {
        Log.i(TAG, Trace.method("create").info("path", path).info("width", width).info("height", height));
        if (Patterns.WEB_URL.matcher(path).matches() || URLUtil.isValidUrl((String)path)) {
            Log.w(TAG, Trace.method("createImage").msg("Create url Image"));
            return new Image(path, width, height);
        }
        if (!FileUtils.exists(path)) {
            Log.w(TAG, Trace.method("createImage").msg("Image not exists"));
            return new Image(path, width, height);
        }
        if (width < 1 || height < 1) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            try {
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
            }
            catch (RuntimeException e) {
                Log.w(TAG, Trace.method("createImage").msg(String.format(Locale.US, "Image decode path: %s, error: %s", path, e.getMessage())));
            }
            return new Image(path, options.outWidth, options.outHeight);
        }
        return new Image(path, width, height);
    }

    @Override
    public Error validContent() {
        if (TextUtils.isEmpty((CharSequence)this.originUrl)) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (this.width < 0 || this.height < 0) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (FileUtils.isNotWebUrl(this.originUrl)) {
            File file = new File(this.originUrl);
            if (file.length() > 0x1400000L) {
                return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
            }
            if (!FileUtils.validImageType(file)) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Content Format Error");
            }
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String toString() {
        String toStr = "width=" + this.width + ", height=" + this.height + ", originUrl='" + this.originUrl + '\'' + ", thumbUrl='" + this.thumbUrl + '\'';
        if (this.getProgress() != null) {
            toStr = toStr + ", " + this.getProgress();
        }
        return String.format(Locale.US, "Image{%s}", toStr);
    }

    public static void registerCodecs() {
        Image.registerCodec(new Content.Codec(){
            static final String KeyWidth = "width";
            static final String KeyHeight = "height";
            static final String KeyOrigin = "origin";
            static final String KeyThumb = "thumb";

            @Override
            public int type() {
                return 1;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Image.class;
            }

            @Override
            public String makeDBString(Content content) throws Throwable {
                boolean flag;
                Image image = (Image)content;
                JSONObject json = new JSONObject();
                json.put(KeyWidth, image.width);
                json.put(KeyHeight, image.height);
                json.put(KeyOrigin, (Object)image.originUrl);
                boolean bl = flag = image.thumbUrl == null || image.thumbUrl.length() == 0;
                if (!flag) {
                    json.put(KeyThumb, (Object)image.thumbUrl);
                }
                return json.toString();
            }

            @Override
            public Content makeChatContent(String data) throws Throwable {
                JSONObject json = new JSONObject(data);
                Image image = new Image(json.getString(KeyOrigin), json.getInt(KeyWidth), json.getInt(KeyHeight));
                if (json.has(KeyThumb)) {
                    image.thumbUrl = json.getString(KeyThumb);
                }
                return image;
            }

            public String toString() {
                return "ImageCodec";
            }
        });
    }
}

