/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.util.Base64;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.model.chat.Content;

public class CustomContent
extends Content {
    public static final int TYPE = 5;
    private final byte[] data;

    public CustomContent(byte[] data) {
        this.data = data;
    }

    @Override
    public Error validContent() {
        if (this.data != null && this.data.length > 32768) {
            return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
        }
        return null;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "CustomContent{data.size=" + this.data.length + '}';
    }

    public static void registerCodecs() {
        CustomContent.registerCodec(new Content.Codec(){

            @Override
            public int type() {
                return 5;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return CustomContent.class;
            }

            @Override
            public String makeDBString(Content content) throws Throwable {
                return Base64.encodeToString((byte[])((CustomContent)content).getData(), (int)0);
            }

            @Override
            public Content makeChatContent(String data) throws Throwable {
                return new CustomContent(Base64.decode((String)data, (int)0));
            }

            public String toString() {
                return "CustomContent";
            }
        });
    }
}

