/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.FileUtils;
import com.hummer.im.model.chat.Content;
import java.io.File;
import java.util.Locale;
import org.json.JSONObject;

public class Audio
extends Content {
    public static final int TYPE = 3;
    private final String url;
    private final int duration;
    private static final String TAG = "Audio";

    private Audio(String url, int duration) {
        this.url = url;
        this.duration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Audio create(String path, int duration) {
        Log.i(TAG, Trace.method("create").info("path", path).info("duration", duration));
        if (FileUtils.isWebUrl(path)) {
            Log.w(TAG, Trace.method("create").msg("Create url Audio"));
            return new Audio(path, duration);
        }
        if (!FileUtils.exists(path)) {
            Log.w(TAG, Trace.method("create").msg("Audio not exists"));
            return new Audio(path, duration);
        }
        if (duration < 1) {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            try {
                retriever.setDataSource(path);
                String durationString = retriever.extractMetadata(9);
                if (durationString != null && !TextUtils.isEmpty((CharSequence)durationString)) {
                    duration = Integer.parseInt(durationString);
                }
            }
            catch (RuntimeException e) {
                Log.w(TAG, Trace.method("create").msg(String.format(Locale.US, "audio path: %s, error: %s", path, e.getMessage())));
                duration = 0;
            }
            finally {
                retriever.release();
            }
            return new Audio(path, duration);
        }
        return new Audio(path, duration);
    }

    @Override
    public Error validContent() {
        if (TextUtils.isEmpty((CharSequence)this.url)) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (this.duration < 0) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (FileUtils.isNotWebUrl(this.url)) {
            File file = new File(this.url);
            if (file.length() > 0x1400000L) {
                return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
            }
            if (!FileUtils.validAudioType(this.url)) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Content Format Error");
            }
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public int getDuration() {
        return this.duration;
    }

    public String toString() {
        String toStr = "url='" + this.url + '\'' + ", duration=" + this.duration;
        if (this.getProgress() != null) {
            toStr = toStr + ", " + this.getProgress();
        }
        return String.format(Locale.US, "Audio{%s}", toStr);
    }

    public static void registerCodecs() {
        Audio.registerCodec(new Content.Codec(){
            private static final String KeyUrl = "url";
            private static final String KeyDuration = "dur";

            @Override
            public int type() {
                return 3;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Audio.class;
            }

            @Override
            public String makeDBString(Content content) throws Throwable {
                Audio audio = (Audio)content;
                JSONObject json = new JSONObject();
                json.put(KeyUrl, (Object)audio.url);
                json.put(KeyDuration, audio.duration);
                return json.toString();
            }

            @Override
            public Content makeChatContent(String data) throws Throwable {
                JSONObject json = new JSONObject(data);
                return new Audio(json.getString(KeyUrl), json.getInt(KeyDuration));
            }

            public String toString() {
                return "AudioCodec";
            }
        });
    }
}

