/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.LinkedList;
import java.util.List;

public final class StringChain {
    private boolean acceptNullElements = false;
    private String name = null;
    private String connector = ":";
    private String delimiter = ", ";
    private List<String> elements = new LinkedList<String>();

    public StringChain setName(@NonNull String name) {
        this.name = name;
        return this;
    }

    public StringChain setConnector(@NonNull String connector) {
        this.connector = connector;
        return this;
    }

    public StringChain setDelimiter(@NonNull String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringChain acceptNullElements() {
        this.acceptNullElements = true;
        return this;
    }

    public StringChain add(@NonNull String lhs, @Nullable Object rhs) {
        if (rhs != null || this.acceptNullElements) {
            this.elements.add(lhs + this.connector + rhs);
        }
        return this;
    }

    public String toString() {
        String string = TextUtils.join((CharSequence)this.delimiter, this.elements);
        if (this.name != null) {
            string = this.name + '{' + string + '}';
        }
        return string;
    }
}

