/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import android.text.TextUtils;
import android.util.Base64;
import com.hummer.im.model.chat.StringChain;
import org.json.JSONException;
import org.json.JSONObject;

public class PushContent {
    private final String title;
    private final String content;
    private final byte[] payload;
    private final String iconUrl;
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_PAYLOAD = "payload";
    private static final String FIELD_ICON_URL = "icon_url";
    private static final String TAG = "PushContent";

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public PushContent(String title, String content, byte[] payload, String iconUrl) {
        this.title = title;
        this.content = content;
        this.payload = payload;
        this.iconUrl = iconUrl;
    }

    public static String makeString(PushContent pushContent) {
        if (pushContent == null) {
            return "";
        }
        JSONObject json = new JSONObject();
        try {
            json.put(FIELD_TITLE, (Object)pushContent.getTitle());
            json.put(FIELD_CONTENT, (Object)pushContent.getContent());
            json.put(FIELD_PAYLOAD, (Object)Base64.encodeToString((byte[])pushContent.getPayload(), (int)0));
            json.put(FIELD_ICON_URL, (Object)pushContent.getIconUrl());
            return json.toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    public static PushContent makeContent(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            return new PushContent(json.getString(FIELD_TITLE), json.getString(FIELD_CONTENT), Base64.decode((String)json.getString(FIELD_PAYLOAD), (int)0), json.getString(FIELD_ICON_URL));
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String toString() {
        return "PushContent{" + new StringChain().add(FIELD_TITLE, this.title).add("cont", this.content).add("iconUrl", this.iconUrl) + "}";
    }
}

