/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Delivering;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.model.chat.store.MessageStoreStrategy;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import java.util.Map;

public final class Message {
    private static final String TAG = "Message";
    private String uuid;
    private Identifiable sender;
    private Identifiable receiver;
    private PushContent pushContent;
    private Long timestamp;
    private State state;
    private String appExtra;
    private Map<String, String> kvExtra;
    private Content chatContent;
    private MessageStoreStrategy storeStrategy = new MessageStoreStrategy();

    public Message() {
        this.uuid = HummerEngine.makeUUID();
        this.timestamp = HummerEngine.getSyncTs();
        this.state = new Init();
    }

    public static State buildSate(int enumValue, int code, String desc) {
        State state = new Init();
        switch (enumValue) {
            case 1: {
                state = new Preparing();
                break;
            }
            case 2: {
                state = new Delivering();
                break;
            }
            case 3: {
                state = new Archived();
                break;
            }
            case 4: {
                state = new Failed(new Error(code, desc));
                break;
            }
        }
        return state;
    }

    public static State buildSate(int enumValue, int code, String desc, Map<String, String> extraInfo) {
        State state = new Init();
        switch (enumValue) {
            case 1: {
                state = new Preparing();
                break;
            }
            case 2: {
                state = new Delivering();
                break;
            }
            case 3: {
                state = new Archived();
                break;
            }
            case 4: {
                state = new Failed(new Error(code, desc, extraInfo));
                break;
            }
        }
        return state;
    }

    public Message(Identifiable receiver, Content content) {
        this(receiver, content, new MessageStoreStrategy());
    }

    public Message(Identifiable receiver, Content content, MessageStoreStrategy storeStrategy) {
        this.chatContent = content;
        this.receiver = receiver;
        this.storeStrategy = storeStrategy;
        this.timestamp = HummerEngine.getSyncTs();
        this.uuid = HummerEngine.makeUUID();
        this.state = new Init();
    }

    public Content getContent() {
        return this.chatContent;
    }

    public void setContent(Content content) {
        this.chatContent = content;
    }

    public PushContent getPushContent() {
        return this.pushContent;
    }

    public void setPushContent(PushContent pushContent) {
        this.pushContent = pushContent;
    }

    public Identifiable getSender() {
        return this.sender;
    }

    public void setSender(Identifiable sender) {
        this.sender = sender;
    }

    public Identifiable getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Identifiable receiver) {
        this.receiver = receiver;
    }

    public Identifiable getTarget() {
        if (this.sender instanceof User && this.receiver instanceof User) {
            if (HMR.isMe(this.sender)) {
                return this.receiver;
            }
            if (HMR.isMe(this.receiver)) {
                return this.sender;
            }
            return null;
        }
        return this.receiver;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long ts) {
        this.timestamp = ts;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    public String getAppExtra() {
        return this.appExtra;
    }

    public void setAppExtra(String appExtra) {
        this.appExtra = appExtra;
    }

    public Map<String, String> getKvExtra() {
        return this.kvExtra;
    }

    public void setKvExtra(Map<String, String> kvExtra) {
        this.kvExtra = kvExtra;
    }

    public State getState() {
        return this.state;
    }

    public void setState(@NonNull State newState) {
        if (newState == null) {
            return;
        }
        this.state = newState;
    }

    public MessageStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public void setStoreStrategy(MessageStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        return this.uuid != null && that.uuid != null && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "Message{uuid='" + this.uuid + '\'' + '}';
    }

    public static interface State {
    }
}

