/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat;

import android.util.Base64;
import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.model.chat.AppContent;
import com.hummer.im.model.chat.CodecManager;
import com.hummer.im.model.chat.ContentProgress;

public class Content {
    public static final int CustomTypeStart = 10000;
    private ContentProgress progress;
    private static final DBCodecs dbCodecs = new DBCodecs();
    protected static final String INVALID_PARAMETER = "Invalid Parameter";
    protected static final String CONTENT_SIZE_LIMIT = "Content Size Limit";
    protected static final String CONTENT_FORMAT_ERROR = "Content Format Error";
    protected static final int FIFTY_MB = 0x3200000;
    protected static final int TWENTY_MB = 0x1400000;

    public ContentProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ContentProgress progress) {
        this.progress = progress;
    }

    public Error validContent() {
        return null;
    }

    public static Integer getDataType(Content content) {
        if (content instanceof AppContent) {
            return ((AppContent)content).getType();
        }
        return (Integer)dbCodecs.getDataType(content);
    }

    public static String makeString(Content content) {
        if (content instanceof AppContent) {
            return Base64.encodeToString((byte[])((AppContent)content).getData(), (int)0);
        }
        return (String)dbCodecs.encode(content);
    }

    public static Content makeContent(int type, String string) {
        if (type >= 10000 && dbCodecs.isNotExistCodec(type)) {
            return new AppContent(type, Base64.decode((String)string, (int)0));
        }
        return (Content)dbCodecs.decode(type, string);
    }

    public static Content makeStringContent(int type, String string) {
        if (type >= 10000 && dbCodecs.isNotExistCodec(type)) {
            return new AppContent(type, string.getBytes());
        }
        return (Content)dbCodecs.decode(type, string);
    }

    protected static void registerCodec(final Codec codec) {
        Log.i("Content", Trace.method("registerCodec").msg("registerCodec").info("type", codec.type()).info("codec", codec));
        dbCodecs.register(new CodecManager.Codec<Integer, String, Content>(){

            @Override
            public Integer getDataType() {
                return codec.type();
            }

            @Override
            public Class<? extends Content> getModelClass() {
                return codec.contentClass();
            }

            @Override
            public String encode(Content content) throws Throwable {
                return codec.makeDBString(content);
            }

            @Override
            public Content decode(String data) throws Throwable {
                return codec.makeChatContent(data);
            }
        });
    }

    private static final class DBCodecs
    extends CodecManager<Integer, String, Content> {
        private DBCodecs() {
        }
    }

    public static interface Codec {
        public int type();

        public Class<? extends Content> contentClass();

        public String makeDBString(Content var1) throws Throwable;

        public Content makeChatContent(String var1) throws Throwable;
    }
}

