/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.ReflectionExt;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceProvider {
    private static final String TAG = "ServiceProvider";
    private static boolean isLoaded = false;
    private static final Set<ModuleLoader> loaders = new HashSet<ModuleLoader>();
    private static final HashMap<Class, Service> services = new HashMap();

    public static void openServices(HMRCompletion completion) {
        List<Service> sortedServices = ServiceProvider.sortServices();
        Log.i(TAG, Trace.method("openServices").msg(ServiceProvider.namesForServices(sortedServices)));
        ServiceProvider.openServices(sortedServices, 0, completion);
    }

    private static void openServices(final List<Service> allServices, final int atPosition, final HMRCompletion completion) {
        if (ServiceProvider.isCloseState() || !HMRContext.isCurrentContext(completion.getRequestId())) {
            Log.i(TAG, Trace.method("login1").msg("Terminal by logout").info("state", (Object)HMR.getState()).info("currentContext", HMRContext.contextId == null ? 0L : HMRContext.contextId.getId()).info("requestId", completion.getRequestId().getId()));
            CompletionUtils.dispatchFailure(completion, new Error(ErrorEnum.BAD_USER_ERROR, "Terminal by logout"));
            return;
        }
        if (atPosition >= allServices.size()) {
            CompletionUtils.dispatchSuccess(completion);
            return;
        }
        final Service service = allServices.get(atPosition);
        service.openService(new HMRCompletion(completion.getRequestId()).onSuccess(new OnSuccess(){

            @Override
            public void onSuccess() {
                Log.d(ServiceProvider.TAG, String.format("openService | Success - %s", service.getClass().getSimpleName()));
                ServiceProvider.openServices(allServices, atPosition + 1, completion);
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                Log.e(ServiceProvider.TAG, Trace.method("openService").msg("Failed - %s, error: %s", service.getClass().getSimpleName(), error));
                for (int pos = atPosition - 1; pos >= 0; --pos) {
                    ((Service)allServices.get(pos)).closeService();
                    Log.i(ServiceProvider.TAG, Trace.method("[rollback]closeService").msg(((Service)allServices.get(pos)).getClass().getSimpleName()));
                }
                CompletionUtils.dispatchFailure(completion, error);
            }
        }));
    }

    public static void closeServices() {
        List<Service> sortedServices = ServiceProvider.sortServices();
        Log.i(TAG, Trace.method("closeServices").msg(ServiceProvider.namesForServices(sortedServices)));
        Collections.reverse(sortedServices);
        for (Service service : sortedServices) {
            service.closeService();
            Log.i(TAG, Trace.method("closeService").msg(service.getClass().getSimpleName()));
        }
    }

    private static List<Service> sortServices() {
        ArrayList<Service> serviceList = new ArrayList<Service>(services.values());
        for (Service service : serviceList) {
            service.serviceSort();
        }
        Collections.sort(serviceList, new Comparator<Service>(){

            @Override
            public int compare(Service o1, Service o2) {
                return o1.serviceSort() - o2.serviceSort();
            }
        });
        return serviceList;
    }

    private static String namesForServices(List<Service> services) {
        ArrayList<String> names = new ArrayList<String>();
        for (Service svc : services) {
            names.add(svc.getClass().getSimpleName());
        }
        return TextUtils.join((CharSequence)", ", names);
    }

    public static void register(Class<?> interfaceClass, Service service) {
        services.put(interfaceClass, service);
    }

    public static <Interface> Interface get(Class<Interface> serviceClass) {
        if (serviceClass == null) {
            Log.e(TAG, Trace.method("get").info("Exception", "null"));
            return null;
        }
        if (services.isEmpty()) {
            ServiceProvider.loadServicesIfNeeded("com.hummer.im");
        }
        for (Map.Entry<Class, Service> impl : services.entrySet()) {
            if (!serviceClass.isAssignableFrom(impl.getKey())) continue;
            return (Interface)impl.getValue();
        }
        Service service = services.get(serviceClass);
        if (service == null) {
            Log.e(TAG, Trace.method("get").info("Service Not Found:", serviceClass.getName()));
        }
        return (Interface)service;
    }

    public static void loadServicesIfNeeded(String packageName) {
        if (isLoaded) {
            return;
        }
        Set<Class<?>> loaderClasses = ReflectionExt.loadClasses(packageName, Object.class, new ReflectionExt.Filter(){

            @Override
            public boolean shouldAccept(String className) {
                String simpleName = className.substring(className.lastIndexOf(".") + 1);
                return simpleName.startsWith("SP") && simpleName.endsWith("ModuleLoader");
            }
        });
        try {
            ServiceProvider.registerServicesByModuleLoaders(loaderClasses);
        }
        catch (Exception e) {
            Log.e(TAG, Trace.method("loadServicesIfNeeded").msg("Fail loading services" + e.getLocalizedMessage()));
        }
        isLoaded = true;
    }

    private static void registerServicesByModuleLoaders(Set<Class<?>> loaderClasses) throws InstantiationException, IllegalAccessException {
        for (Class<?> loaderClazz : loaderClasses) {
            ModuleLoader loader = (ModuleLoader)loaderClazz.newInstance();
            loader.initModule();
            loaders.add(loader);
            Map<Class, Service> services = loader.getServices();
            for (Map.Entry<Class, Service> entry : services.entrySet()) {
                ServiceProvider.register(entry.getKey(), entry.getValue());
                entry.getValue().initService();
            }
        }
    }

    public static boolean isCloseState() {
        return HMR.getState() == HMR.State.Closing || HMR.getState() == HMR.State.Closed;
    }

    public static interface Service {
        public void initService();

        public void openService(@NonNull HMRCompletion var1);

        public int serviceSort();

        public void closeService();
    }

    public static interface ModuleLoader {
        public void initModule();

        public void deInitModule();

        public Map<Class, Service> getServices();
    }
}

