/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import java.util.UUID;

public final class LogId {
    private long mBeginTime = System.currentTimeMillis() / 1000L;
    private long mDeviceHashID = 0L;
    private long mCurrLoopCnt = 0L;
    private static final long MAX_10BIT_NUM = 1024L;
    private static final long MAX_18BIT_NUM = 262144L;
    private static final LogId instance = new LogId();

    public static long generate() {
        return instance.makeId();
    }

    private LogId() {
        try {
            String deviceId = UUID.randomUUID().toString();
            byte[] deviceIdBytes = deviceId.getBytes();
            this.mDeviceHashID = this.genHashNum(deviceIdBytes);
        }
        catch (Throwable t) {
            Log.e("LogId", Trace.method("LogId").msg("Failed constructing IDGenerator").info("exception", t.getMessage()));
        }
    }

    private long makeId() {
        if (this.mCurrLoopCnt >= 1023L) {
            this.mBeginTime = System.currentTimeMillis() / 1000L;
            this.mCurrLoopCnt = 0L;
        }
        long resID = this.mBeginTime << 32 & 0x7FFFFFFF00000000L;
        long mTermType = 1L;
        resID |= mTermType << 28 & 0xFFFFFFFFF0000000L;
        resID |= this.mDeviceHashID << 10 & 0xFFFFC00L;
        ++this.mCurrLoopCnt;
        return resID |= this.mCurrLoopCnt & 0x3FFL;
    }

    private long genHashNum(byte[] data) {
        if (data == null || data[0] == 0) {
            return 0L;
        }
        long resHash = 5381L;
        int curr = 0;
        int end = data.length;
        while (curr < end) {
            resHash *= 33L;
            resHash ^= (long)data[curr];
            if (0 != ++curr) continue;
        }
        return resHash %= 262144L;
    }

    private final class Terminal {
        static final int ANDROID = 1;

        private Terminal() {
        }
    }
}

