/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import java.util.LinkedList;
import java.util.List;

public final class HMRCompletion {
    private static final String TAG = "HMRCompletion";
    private final DispatchQueue dispatchQueue;
    private List<Runnable> preSuccess = new LinkedList<Runnable>();
    private OnSuccess successHandler;
    private List<Runnable> postSuccess = new LinkedList<Runnable>();
    private List<Runnable> preFailure = new LinkedList<Runnable>();
    private OnFailure failureHandler;
    private List<Runnable> postFailure = new LinkedList<Runnable>();
    private HMRCompletion decorated;
    private RequestId requestId = new RequestId(0L);

    public HMRCompletion() {
        Looper looper = Looper.myLooper();
        this.dispatchQueue = looper == Looper.getMainLooper() ? new DispatchQueue(new DispatchQueue.LooperHandlerProvider(Looper.getMainLooper())) : (looper == HMRContext.work.getHandler().getLooper() ? HMRContext.work : DispatchQueue.direct);
    }

    public HMRCompletion(@NonNull RequestId requestId) {
        this();
        this.requestId = requestId;
    }

    public HMRCompletion(final @NonNull RequestId requestId, final @Nullable HMR.Completion completion) {
        this();
        this.requestId = requestId;
        this.onSuccess(new OnSuccess(){

            @Override
            public void onSuccess() {
                if (completion != null) {
                    Log.i(HMRCompletion.TAG, Trace.method(HMRCompletion.TAG).msg("Success").info("hummerRequestId", requestId));
                    completion.onSuccess();
                }
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                if (completion != null) {
                    Log.i(HMRCompletion.TAG, Trace.method(HMRCompletion.TAG).msg("Fail").info("hummerRequestId", requestId).info("Error", error.toString()));
                    completion.onFailed(error);
                }
            }
        });
    }

    public HMRCompletion(@NonNull Handler handler) {
        this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(handler.getLooper()));
    }

    public HMRCompletion decorate(@Nullable HMRCompletion decorated) {
        if (this.decorated == null) {
            Log.e(TAG, Trace.method("decorate").info("\u53ea\u5141\u8bb8\u5bf9Completion\u8fdb\u884c\u4e00\u6b21\u88c5\u9970", this.decorated));
            return this;
        }
        this.decorated = decorated;
        return this;
    }

    public HMRCompletion beforeSuccess(@NonNull Runnable runnable) {
        this.preSuccess.add(runnable);
        return this;
    }

    public HMRCompletion onSuccess(@NonNull OnSuccess success) {
        this.successHandler = success;
        return this;
    }

    public HMRCompletion afterSuccess(@NonNull Runnable runnable) {
        this.postSuccess.add(0, runnable);
        return this;
    }

    public HMRCompletion beforeFailure(@NonNull Runnable runnable) {
        this.preFailure.add(runnable);
        return this;
    }

    public HMRCompletion onFailure(@NonNull OnFailure failure) {
        this.failureHandler = failure;
        return this;
    }

    public HMRCompletion afterFailure(@NonNull Runnable runnable) {
        this.postFailure.add(0, runnable);
        return this;
    }

    void dispatchSuccess() {
        this.dispatchQueue.async(new Runnable(){

            @Override
            public void run() {
                HMRCompletion.dispatchActions(HMRCompletion.this.preSuccess);
                if (HMRCompletion.this.successHandler != null) {
                    HMRCompletion.this.successHandler.onSuccess();
                } else {
                    Log.i(HMRCompletion.TAG, Trace.method("dispatchSuccess").msg("dispatchSuccess, successHandler == null"));
                }
                CompletionUtils.dispatchSuccess(HMRCompletion.this.decorated);
                HMRCompletion.dispatchActions(HMRCompletion.this.postSuccess);
            }
        });
    }

    void dispatchFailure(final @NonNull Error error) {
        this.dispatchQueue.async(new Runnable(){

            @Override
            public void run() {
                HMRCompletion.dispatchActions(HMRCompletion.this.preFailure);
                if (HMRCompletion.this.failureHandler != null) {
                    HMRCompletion.this.failureHandler.onFailure(error);
                } else {
                    Log.i(HMRCompletion.TAG, Trace.method("dispatchFailure").msg("dispatchFailure, failureHandler == null"));
                }
                CompletionUtils.dispatchFailure(HMRCompletion.this.decorated, error);
                HMRCompletion.dispatchActions(HMRCompletion.this.postFailure);
            }
        });
    }

    private static void dispatchActions(@NonNull List<Runnable> actions) {
        for (Runnable r : actions) {
            r.run();
        }
    }

    public RequestId getRequestId() {
        return this.requestId;
    }
}

