/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.utility;

import android.text.TextUtils;
import android.util.Patterns;
import android.webkit.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileUtils {
    public static boolean exists(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists() && !file.isDirectory();
    }

    public static boolean isWebUrl(String url) {
        return Patterns.WEB_URL.matcher(url).matches() || URLUtil.isValidUrl((String)url);
    }

    public static boolean isNotWebUrl(String url) {
        return !FileUtils.isWebUrl(url);
    }

    public static boolean validImageType(File imageFile) {
        String header = FileUtils.getFileHeader(imageFile);
        if (TextUtils.isEmpty((CharSequence)header)) {
            return false;
        }
        return header.contains(FileType.JPG.getHeader()) || header.contains(FileType.PNG.getHeader()) || header.contains(FileType.BMP.getHeader());
    }

    public static boolean validAudioType(String audioPath) {
        return FileUtils.validFileSuffix(audioPath, "aac");
    }

    public static boolean validVideoType(String videoPath) {
        return FileUtils.validFileSuffix(videoPath, "mp4");
    }

    private static boolean validFileSuffix(String path, String validSuffix) {
        if (TextUtils.isEmpty((CharSequence)validSuffix)) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        int index = path.lastIndexOf(".");
        if (index > 0) {
            String fileSuffix = path.substring(index + 1);
            return !TextUtils.isEmpty((CharSequence)fileSuffix) && validSuffix.equals(fileSuffix.toLowerCase());
        }
        return false;
    }

    public static String getFileHeader(String filePath) {
        if (filePath == null || filePath.length() < 1) {
            return null;
        }
        return FileUtils.getFileHeader(new File(filePath));
    }

    public static String getFileHeader(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] b = new byte[4];
            fis.read(b, 0, b.length);
            return FileUtils.bytesToHexString(b);
        }
        catch (IOException e) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static String bytesToHexString(byte[] src) {
        if (src == null || src.length <= 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : src) {
            String hv = Integer.toHexString(b & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    public static enum FileType {
        JPG("FFD8FF"),
        PNG("89504E47"),
        BMP("424D");

        private final String header;

        private FileType(String header) {
            this.header = header;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

