/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.log;

import android.text.TextUtils;
import com.hummer.im._internals.utility.LogId;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class Trace {
    private final List<String> parameters = new LinkedList<String>();
    private String methodName;
    private String message;
    private Long flowElapsed = null;
    private String flowName = null;

    public static Trace method(String methodName) {
        return new Trace(methodName);
    }

    public Trace msg(String fmt, Object ... args) {
        this.message = String.format(Locale.US, fmt, args);
        return this;
    }

    public Trace msg(Object obj) {
        this.message = obj == null ? "null" : obj.toString();
        return this;
    }

    public Trace info(String name, Object value) {
        this.parameters.add(name + ":" + value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.flowName != null) {
            sb.append(String.format(Locale.US, "[%s]", this.flowName));
        }
        sb.append(this.methodName);
        if (this.flowElapsed != null && this.flowElapsed >= 10L) {
            sb.append("(");
            sb.append(this.flowElapsed);
            sb.append("ms)");
        }
        if (this.message != null || this.parameters.size() > 0) {
            sb.append(" |");
        }
        if (this.message != null) {
            sb.append(" ");
            sb.append(this.message);
        }
        if (this.parameters.size() > 0) {
            sb.append(" {");
            sb.append(TextUtils.join((CharSequence)", ", this.parameters));
            sb.append("}");
        }
        this.parameters.clear();
        this.message = null;
        return sb.toString();
    }

    private Trace(String methodName) {
        this.methodName = methodName;
    }

    private Trace asFlow(String name, Long elapsed) {
        this.flowName = name;
        this.flowElapsed = elapsed;
        return this;
    }

    public static class Flow {
        public final long logId;
        private final String name;
        private final ArrayList<Long> timestamps = new ArrayList();

        public Flow() {
            this.logId = LogId.generate();
            this.name = String.format(Locale.US, "%-19d", this.logId);
        }

        public Trace method(String methodName) {
            return new Trace(methodName).asFlow(this.name, this.getIntervalByAdvancingTimestamp());
        }

        private Long getIntervalByAdvancingTimestamp() {
            Long now = System.currentTimeMillis();
            Long interval = null;
            if (this.timestamps.size() >= 1) {
                Long last = this.timestamps.get(this.timestamps.size() - 1);
                interval = now - last;
            }
            this.timestamps.add(now);
            return interval;
        }
    }
}

