/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.log;

import android.os.Process;
import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public final class Log {
    private static Logger logger;

    public static void v(String tag, Object msg) {
        Log.write(0, tag, msg.toString());
    }

    public static void d(String tag, Object msg) {
        Log.write(1, tag, msg.toString());
    }

    public static void i(String tag, Object msg) {
        Log.write(2, tag, msg.toString());
    }

    public static void w(String tag, Object msg) {
        Log.write(3, tag, msg.toString());
    }

    public static void e(String tag, Object msg) {
        Log.write(4, tag, msg.toString());
    }

    public static void r(String tag, Object msg) {
        Log.write(10, tag, msg.toString());
    }

    public static void setLogger(@NonNull Logger logger) {
        Log.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    private static void write(int level, String tag, String message) {
        if (logger != null) {
            logger.log(level, Log.stringFrom(tag, message));
        } else {
            android.util.Log.println((int)level, (String)"", (String)Log.stringFrom(tag, message));
        }
    }

    private static String stringFrom(String tag, String message) {
        Thread currentThread = Thread.currentThread();
        String threadInfo = currentThread.getName();
        int pid = Process.myPid();
        if (tag == null) {
            return String.format(Locale.US, "(%d-%-12s)%s", pid, threadInfo, message, pid);
        }
        return String.format(Locale.US, "(%d-%-12s)[%s] %s", pid, threadInfo, tag, message);
    }

    public static interface Logger {
        public void log(int var1, String var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Level {
        }
    }
}

