/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.log;

import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.log.Log;

public class HummerLog
implements Log.Logger {
    public static final int LOG_LEVEL_VERBOSE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    public static final int LOG_LEVEL_RELEASE = 10;
    private static volatile HummerLog instance;
    private static final Object SYNC_LOCK;
    private static final Object SYNC_LOG_CALLBACK;
    private static final String TAG = "HummerLog";
    private static int sLogLevel;
    private final String module;
    private static HMR.HMRLogCallback mLogCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HummerLog instance() {
        if (instance == null) {
            Object object = SYNC_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new HummerLog("Hummer");
                }
            }
        }
        return instance;
    }

    private HummerLog(String module) {
        this.module = module;
    }

    public void setLogLevel(int level) {
        sLogLevel = level;
        HummerNative.setLogLevel(level);
    }

    @Override
    public void log(int lv, String msg) {
        switch (lv) {
            case 2: {
                HummerLog.putLog(2, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
                break;
            }
            case 4: {
                HummerLog.putLog(4, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
                break;
            }
            case 3: {
                HummerLog.putLog(3, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
                break;
            }
            case 1: {
                HummerLog.putLog(1, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
                break;
            }
            case 10: {
                HummerLog.putLog(10, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
                break;
            }
            case 0: {
                HummerLog.putLog(0, 0, this.module.getBytes(), null, null, 0, msg.getBytes());
            }
        }
    }

    public void enableConsoleLogger(boolean bEnable) {
        Log.d(TAG, "enableConsoleLogger, bEnable " + bEnable);
        HummerNative.disableLogConsole(!bEnable);
    }

    public long setLogFilePath(String filePath) {
        return HummerNative.setLogFilePath(filePath);
    }

    public static void putLog(int level, int module, byte[] moduleName, byte[] tag, byte[] methodName, int line, byte[] msg) {
        if (level < sLogLevel) {
            return;
        }
        if (msg == null || msg.length <= 0) {
            return;
        }
        if (moduleName == null) {
            moduleName = "Hummer".getBytes();
        }
        if (tag == null) {
            tag = TAG.getBytes();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (methodName != null && methodName.length > 0) {
            stringBuilder.append("[").append(new String(methodName)).append("]");
        }
        stringBuilder.append(line);
        stringBuilder.append(new String(msg));
        HummerNative.logText(level, module, new String(moduleName), new String(tag), stringBuilder.toString());
    }

    public void uploadLog(String note) {
        HummerNative.uploadLog(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogCallback(HMR.HMRLogCallback callback) {
        Object object = SYNC_LOG_CALLBACK;
        synchronized (object) {
            mLogCallback = callback;
            if (callback != null) {
                HummerNative.setLogCallback(true);
            } else {
                HummerNative.setLogCallback(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logCallback(int level, String msg) {
        Object object = SYNC_LOG_CALLBACK;
        synchronized (object) {
            if (mLogCallback != null) {
                mLogCallback.onHmrLogWithLevel(HMR.HMRLogLevel.toLevel(level), msg);
            }
        }
    }

    static {
        SYNC_LOCK = new Object();
        SYNC_LOG_CALLBACK = new Object();
        sLogLevel = 0;
    }
}

