/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import android.text.TextUtils;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.message.TextMessageImpl;
import com.hummer.im.model.chat.AppContent;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.ContentProgress;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.contents.Audio;
import com.hummer.im.model.chat.contents.CustomContent;
import com.hummer.im.model.chat.contents.Image;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.chat.contents.Video;
import com.hummer.im.model.chat.store.MessageStoreStrategy;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.User;
import com.hummer.im.model.message.BaseMessage;
import com.hummer.im.model.message.MessageType;
import com.hummer.im.model.user.UserOnlineStatus;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HummerNotification {
    public static final int NOTIFY_HUMMER_STATE_CHANGED = 100;
    public static final int NOTIFY_HUMMER_KICKED = 101;
    public static final int NOTIFY_HUMMER_TOKEN_EXPIRED = 102;
    public static final int NOTIFY_HUMMER_LOGIN = 103;
    public static final int NOTIFY_HUMMER_REFRESH_TOKEN = 104;
    public static final int NOTIFY_HUMMER_LOGOUT = 105;
    public static final int NOTIFY_HUMMER_REFRESH_TOKEN_1 = 106;
    public static final int NOTIFY_HUMMER_TOKEN_WILL_EXPIRED = 107;
    public static final int NOTIFY_HUMMER_LOG_WITH_LEVEL = 108;
    public static final int NOTIFY_HUMMER_SEND_P2P_MESSAGE = 160;
    public static final int NOTIFY_HUMMER_FETCH_USER_ONLINE_STATUS = 161;
    public static final int NOTIFY_ON_P2P_MESSAGE_RECEIVED = 186;
    public static final int NOTIFY_REPORT_INIT = 200;
    public static final int NOTIFY_REPORT_AREA = 201;
    public static final int NOTIFY_REPORT_METRICS_RETURN_CODE = 202;
    public static final int NOTIFY_REPORT = 203;
    public static final int NOTIFY_ON_SEND_MESSAGE = 301;
    public static final int NOTIFY_ON_BEFORE_SEND_MESSAGE = 302;
    public static final int NOTIFY_ON_AFTER_SEND_MESSAGE = 303;
    public static final int NOTIFY_ON_BEFORE_RECEIVE_MESSAGE = 304;
    public static final int NOTIFY_ON_AFTER_RECEIVE_MESSAGE = 305;
    public static final int NOTIFY_ON_UPDATE_MESSAGE_STATE = 306;
    public static final int NOTIFY_ON_MESSAGE_STATE_UPDATED = 307;
    public static final int NOTIFY_ON_MESSAGE_PREPARE_PROGRESS = 308;
    public static final int NOTIFY_ON_MESSAGE_RECEIVED = 309;

    public static class NotifyOnMessage<T>
    extends NotifyBase<T> {
        private Message message;

        @Override
        public void unmarshall(byte[] buf) {
            Content content;
            super.unmarshall(buf);
            int stateType = this.popInt();
            int stateCode = this.popInt();
            String stateDesc = this.popString16UTF8();
            Map<String, String> extraInfo = this.popMap(String.class, String.class);
            String uuid = this.popString16UTF8();
            long timestamp = this.popInt64();
            String sender = this.popString16UTF8();
            String receiver = this.popString16UTF8();
            String extra = this.popString16UTF8();
            Map<String, String> kvExtra = this.popMap(String.class, String.class);
            int msgType = this.popInt();
            if (msgType == 0) {
                content = new Text(this.popString32("UTF-8"));
            } else if (msgType == 1) {
                String originUrl = this.popString16UTF8();
                String thumbUrl = this.popString16UTF8();
                int width = this.popInt();
                int height = this.popInt();
                Image image = Image.create(originUrl, width, height);
                image.setThumbUrl(thumbUrl);
                content = image;
            } else if (msgType == 3) {
                String url = this.popString16UTF8();
                int duration = this.popInt();
                content = Audio.create(url, duration);
            } else if (msgType == 4) {
                String videoUrl = this.popString16UTF8();
                int videoSize = this.popInt();
                int videoWidth = this.popInt();
                int videoHeight = this.popInt();
                int videoDuration = this.popInt();
                String coverUrl = this.popString16UTF8();
                String coverThumbUrl = this.popString16UTF8();
                int coverWidth = this.popInt();
                int coverHeight = this.popInt();
                Video video = Video.create(videoUrl, videoSize, videoWidth, videoHeight, videoDuration, coverUrl, coverWidth, coverHeight);
                video.setCoverThumbUrl(coverThumbUrl);
                content = video;
            } else if (msgType == 5) {
                content = new CustomContent(this.popBytes32());
            } else if (msgType >= 10000) {
                content = new AppContent(msgType, this.popBytes32());
            } else {
                Log.e("HummerNotification", "msgType cannot parse, msgType: " + msgType);
                content = null;
            }
            boolean isRemoteHistoryMessage = this.popBool();
            boolean isLocalHistoryMessage = this.popBool();
            boolean isLastMessage = this.popBool();
            boolean isUnreadCount = this.popBool();
            MessageStoreStrategy storeStrategy = new MessageStoreStrategy(isRemoteHistoryMessage, isLocalHistoryMessage, isLastMessage, isUnreadCount);
            String pushTitle = this.popString32("UTF-8");
            String pushContent = this.popString32("UTF-8");
            String pushIconUrl = this.popString32("UTF-8");
            byte[] pushPayload = this.popBytes32();
            PushContent push = null;
            if (!TextUtils.isEmpty((CharSequence)pushTitle) || !TextUtils.isEmpty((CharSequence)pushContent) || !TextUtils.isEmpty((CharSequence)pushIconUrl) || pushPayload != null && pushPayload.length > 0) {
                push = new PushContent(pushTitle, pushContent, pushPayload, pushIconUrl);
            }
            Message message = new Message();
            message.setState(Message.buildSate(stateType, stateCode, stateDesc, extraInfo));
            message.setUuid(uuid);
            message.setTimestamp(timestamp);
            message.setSender(IDFactory.makeId(sender));
            message.setReceiver(IDFactory.makeId(receiver));
            message.setAppExtra(extra);
            message.setKvExtra(kvExtra);
            message.setContent(content);
            message.setStoreStrategy(storeStrategy);
            message.setPushContent(push);
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }
    }

    public static class OnMessageReceived {
        private final Message message;

        public OnMessageReceived(Message message) {
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }
    }

    public static class NotifyOnMessageReceived
    extends NotifyOnMessage<OnMessageReceived> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.setNotification(new OnMessageReceived(this.getMessage()));
        }
    }

    public static class OnMessagePrepareProgress {
        private final long requestId;
        private final Message message;

        public OnMessagePrepareProgress(long requestId, Message message, long total, long current) {
            this.requestId = requestId;
            ContentProgress progress = new ContentProgress(total, current);
            message.getContent().setProgress(progress);
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }

        public long getRequestId() {
            return this.requestId;
        }
    }

    public static class NotifyOnMessagePrepareProgress
    extends NotifyOnMessage<OnMessagePrepareProgress> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            long total = this.popInt64();
            long current = this.popInt64();
            this.setNotification(new OnMessagePrepareProgress(requestId, this.getMessage(), total, current));
        }
    }

    public static class OnMessageStateUpdated {
        private final long requestId;
        private final Message message;

        public OnMessageStateUpdated(long requestId, Message message) {
            this.requestId = requestId;
            this.message = message;
        }

        public Message getMessage() {
            return this.message;
        }

        public long getRequestId() {
            return this.requestId;
        }
    }

    public static class NotifyOnMessageStateUpdated
    extends NotifyOnMessage<OnMessageStateUpdated> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            this.setNotification(new OnMessageStateUpdated(requestId, this.getMessage()));
        }
    }

    public static class OnP2PMessageReceived {
        private User user;
        private BaseMessage baseMessage;

        public OnP2PMessageReceived(User user, BaseMessage baseMessage) {
            this.user = user;
            this.baseMessage = baseMessage;
        }

        public User getUser() {
            return this.user;
        }

        public BaseMessage getBaseMessage() {
            return this.baseMessage;
        }
    }

    public static class NotifyOnP2PMessageReceived
    extends NotifyBase<OnP2PMessageReceived> {
        @Override
        public void unmarshall(byte[] buf) {
            TextMessageImpl message;
            super.unmarshall(buf);
            long userId = this.popInt64();
            String uuid = this.popString16UTF8();
            long ts = this.popInt64();
            int msgType = this.popInt();
            Map<String, String> extra = this.popMap(String.class, String.class);
            if (msgType == MessageType.TEXT.getType()) {
                String text = this.popString32("utf-8");
                message = new TextMessageImpl(uuid, ts, text);
                ((BaseMessage)message).setExtra(extra);
            } else {
                message = null;
            }
            this.setNotification(new OnP2PMessageReceived(new User(userId), message));
        }
    }

    public static class OnFetchUserOnlineStatus
    extends BaseCallback {
        private Set<UserOnlineStatus> status;

        public OnFetchUserOnlineStatus(long requestId, int code, String desc, Set<UserOnlineStatus> status) {
            super(requestId, code, desc);
            this.status = status;
        }

        public Set<UserOnlineStatus> getStatus() {
            return this.status;
        }
    }

    public static class NotifyOnFetchUserOnlineStatus
    extends NotifyBase<OnFetchUserOnlineStatus> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            int code = this.popInt();
            String desc = this.popString16UTF8();
            Map<Long, Integer> statusMap = this.popMap(Long.class, Integer.class);
            HashSet<UserOnlineStatus> status = new HashSet<UserOnlineStatus>(statusMap.size());
            for (Map.Entry<Long, Integer> entry : statusMap.entrySet()) {
                status.add(new UserOnlineStatus(new User(entry.getKey()), UserOnlineStatus.OnlineStatus.getOnlineStatus(entry.getValue())));
            }
            this.setNotification(new OnFetchUserOnlineStatus(requestId, code, desc, status));
        }
    }

    public static class OnSendMessage {
        private long requestId;
        private int code;
        private String desc;
        private Map<String, String> extraInfo;
        private Message message;

        public OnSendMessage(long requestId, int code, String desc, Map<String, String> info, Message message) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
            this.extraInfo = info;
            this.message = message;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        public Message getMessage() {
            return this.message;
        }

        public Map<String, String> getExtraInfo() {
            return this.extraInfo;
        }
    }

    public static class OnMessage {
        private Message message;
        private int msgType;
        private long userId;
        private long roomId;
        private String data;

        public OnMessage(Message message, int msgType, long userId, long roomId, String data) {
            this.message = message;
            this.msgType = msgType;
            this.userId = userId;
            this.roomId = roomId;
            this.data = data;
        }

        public Message getMessage() {
            return this.message;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public void setMsgType(int msgType) {
            this.msgType = msgType;
        }

        public long getUserId() {
            return this.userId;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public long getRoomId() {
            return this.roomId;
        }

        public void setRoomId(long roomId) {
            this.roomId = roomId;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    public static class Report {
        private String type;
        private Map<String, String> data;

        public Report(String type, Map<String, String> data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getData() {
            return this.data;
        }
    }

    public static class ReportMetricsReturnCode {
        private int scode;
        private String uri;
        private long timeConsumption;
        private String code;

        public ReportMetricsReturnCode(int scode, String uri, long timeConsumption, String code) {
            this.scode = scode;
            this.uri = uri;
            this.timeConsumption = timeConsumption;
            this.code = code;
        }

        public int getSCode() {
            return this.scode;
        }

        public String getUri() {
            return this.uri;
        }

        public long getTimeConsumption() {
            return this.timeConsumption;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static class ReportArea {
        private int area;

        public ReportArea(int area) {
            this.area = area;
        }

        public int getArea() {
            return this.area;
        }
    }

    public static class ReportInit {
        private String appKey;
        private String version;
        private String from;

        public ReportInit(String appKey, String version, String from) {
            this.appKey = appKey;
            this.version = version;
            this.from = from;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFrom() {
            return this.from;
        }
    }

    public static class HummerLogout {
        private long requestId;
        private int code;
        private String desc;

        public HummerLogout(long requestId, int code, String desc) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static class HummerRefreshToken {
        private long requestId;
        private int code;
        private String desc;

        public HummerRefreshToken(long requestId, int code, String desc) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static class HummerLogin {
        private long requestId;
        private long userId;
        private int code;
        private String desc;

        public HummerLogin(long requestId, long userId, int code, String desc) {
            this.requestId = requestId;
            this.userId = userId;
            this.code = code;
            this.desc = desc;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public long getUserId() {
            return this.userId;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static class HummerKicked {
        private int code;
        private String description;

        public HummerKicked(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class HummerLogCallback {
        private int level;
        private String log;

        public HummerLogCallback(int level, String log) {
            this.level = level;
            this.log = log;
        }

        public int getLevel() {
            return this.level;
        }

        public String getLog() {
            return this.log;
        }
    }

    public static class HummerStateChanged {
        private int oldState;
        private int newState;
        private String reason;

        public HummerStateChanged(int oldState, int newState, String reason) {
            this.oldState = oldState;
            this.newState = newState;
            this.reason = reason;
        }

        public int getOldState() {
            return this.oldState;
        }

        public int getNewState() {
            return this.newState;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static class BaseCallback {
        private long requestId;
        private int code;
        private String desc;

        public BaseCallback(long requestId, int code, String desc) {
            this.requestId = requestId;
            this.code = code;
            this.desc = desc;
        }

        public long getRequestId() {
            return this.requestId;
        }

        public void setRequestId(long requestId) {
            this.requestId = requestId;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class NotifyBaseCallback
    extends NotifyBase<BaseCallback> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.setNotification(new BaseCallback(this.popInt64(), this.popInt(), this.popString16UTF8()));
        }
    }

    public static class NotifyBase<T>
    extends Marshallable {
        private T notification;

        public T get() {
            return this.notification;
        }

        public void setNotification(T notification) {
            this.notification = notification;
        }
    }
}

