/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im._internals.ChatServiceImpl;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im._internals.bridge.helper.HummerEvent;
import com.hummer.im._internals.bridge.marshall.MshBuffer;
import com.hummer.im._internals.bridge.marshall.NativeByteBufferPool;
import com.hummer.im._internals.log.Log;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.MessageOptions;
import com.hummer.im.model.message.TextMessage;
import com.hummer.im.model.option.FetchStrategy;
import com.hummer.im.model.option.HummerOptions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class HummerNative {
    private static final Set<NotificationListener> mNotificationListeners = new CopyOnWriteArraySet<NotificationListener>();
    private static final String TAG = "HummerNativeJ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNotificationListener(NotificationListener listener) {
        if (listener != null) {
            Set<NotificationListener> set = mNotificationListeners;
            synchronized (set) {
                mNotificationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notificationCallback(int type, byte[] data) {
        if (type == 108) {
            HummerEngine.getInstance().handleLogCallback(data);
            return;
        }
        Log.i(TAG, "handleNotify | type: " + type);
        Set<NotificationListener> set = mNotificationListeners;
        synchronized (set) {
            for (NotificationListener listener : mNotificationListeners) {
                listener.handleNotify(type, data);
            }
        }
    }

    private static native long nativeInit(byte[] var0);

    private static native String nativeSdkGetVersion();

    private static native String nativeMakeUUID();

    private static native long nativeGetSyncTs();

    private static native int nativeSdkGetState(long var0);

    public static native TextMessage nativeCreateTextMessage(String var0);

    public static native long nativeAddMessageListener();

    public static native long nativeRemoveMessageListener();

    public static native long nativeAddMemberListener();

    public static native long nativeRemoveMemberListener();

    public static native long nativeAddRoomListener();

    public static native long nativeRemoveRoomListener();

    public static native long nativeSdkProcess(int var0, byte[] var1);

    public static long sdkProcess(HummerEvent.EventBase e) {
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        long ret = HummerNative.nativeSdkProcess(e.event(), e.HPmarshall(buffer));
        buffer.freeBuffer();
        return ret;
    }

    public static long init(long addId, String appVersion, boolean isDelegateMode) {
        HummerEvent.EventInitSdk event = new HummerEvent.EventInitSdk(addId, appVersion, isDelegateMode);
        MshBuffer buffer = new MshBuffer(4096, NativeByteBufferPool.get());
        byte[] data = event.HPmarshall(buffer);
        long ret = HummerNative.nativeInit(data);
        buffer.freeBuffer();
        return ret;
    }

    public static long login(long requestId, long uid, String region, byte[] token, HummerOptions options) {
        HummerEvent.EventLoginByte event = new HummerEvent.EventLoginByte(requestId, uid, region, token, options);
        return HummerNative.sdkProcess(event);
    }

    public static long logout(long requestId) {
        HummerEvent.EventLogout event = new HummerEvent.EventLogout(requestId);
        long ret = HummerNative.sdkProcess(event);
        return ret;
    }

    public static String getSdkVersion() {
        return HummerNative.nativeSdkGetVersion();
    }

    public static String makeUUID() {
        return HummerNative.nativeMakeUUID();
    }

    public static long getSyncTs() {
        return HummerNative.nativeGetSyncTs();
    }

    public static int getState(long requestId) {
        return HummerNative.nativeSdkGetState(requestId);
    }

    public static long refreshToken(long requestId, String token, HummerOptions options) {
        HummerEvent.EventRefreshToken event = new HummerEvent.EventRefreshToken(requestId, token, options);
        return HummerNative.sdkProcess(event);
    }

    public static long refreshToken1(long requestId, String token, HummerOptions options) {
        HummerEvent.EventRefreshToken event = new HummerEvent.EventRefreshToken(requestId, token, options);
        event.event = 202;
        return HummerNative.sdkProcess(event);
    }

    public static long refreshToken1(long requestId, byte[] token, HummerOptions options) {
        HummerEvent.EventRefreshByteToken event = new HummerEvent.EventRefreshByteToken(requestId, token, options);
        event.event = 205;
        return HummerNative.sdkProcess(event);
    }

    public static long logText(int level, int module, String moduleName, String tag, String text) {
        return HummerNative.sdkProcess(new HummerEvent.EventLogText(level, module, moduleName, tag, text));
    }

    public static long setLogFilePath(String filePath) {
        return HummerNative.sdkProcess(new HummerEvent.EventLogFilePath(filePath));
    }

    public static long setLogLevel(int level) {
        return HummerNative.sdkProcess(new HummerEvent.EventLogSetLevel(level));
    }

    public static long disableLogConsole(boolean disable) {
        return HummerNative.sdkProcess(new HummerEvent.EventLogDisableConsole(disable));
    }

    public static long uploadLog(String note) {
        return HummerNative.sdkProcess(new HummerEvent.EventUploadLog(note));
    }

    public static long setDebugMode(boolean enable) {
        HummerEvent.EventLogDisableConsole event = new HummerEvent.EventLogDisableConsole(enable);
        event.event = 110;
        return HummerNative.sdkProcess(event);
    }

    public static long setLogCallback(boolean enable) {
        HummerEvent.EventLogDisableConsole event = new HummerEvent.EventLogDisableConsole(enable);
        event.event = 111;
        return HummerNative.sdkProcess(event);
    }

    public static long setFetchStrategy(FetchStrategy strategy) {
        return HummerNative.sdkProcess(new HummerEvent.EventSetFetchStrategy(strategy));
    }

    public static long sendMessage(long requestId, ChatServiceImpl.MessagePacket packet) {
        return HummerNative.sdkProcess(new HummerEvent.EventSendMessage(requestId, packet));
    }

    public static void sendMessage(long requestId, Message message, MessageOptions options) {
        HummerNative.sdkProcess(new HummerEvent.EventSendMessageWithOptions(requestId, message, options));
    }

    public static long reportReturnCode(String funcName, long rtt, int code) {
        return HummerNative.sdkProcess(new HummerEvent.EventReportReturnCode(funcName, rtt, code));
    }

    static {
        try {
            System.loadLibrary("core");
        }
        catch (Throwable e) {
            e.printStackTrace();
            android.util.Log.e((String)TAG, (String)"load core sdk failed!");
        }
    }

    public static interface NotificationListener {
        public void handleNotify(int var1, byte[] var2);
    }
}

