/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im._internals.ChatServiceImpl;
import com.hummer.im._internals.bridge.marshall.HPMarshaller;
import com.hummer.im.model.chat.AppContent;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.MessageOptions;
import com.hummer.im.model.chat.contents.Audio;
import com.hummer.im.model.chat.contents.CustomContent;
import com.hummer.im.model.chat.contents.Image;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.chat.contents.Video;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.User;
import com.hummer.im.model.message.BaseMessage;
import com.hummer.im.model.message.P2PMessageOptions;
import com.hummer.im.model.message.TextMessage;
import com.hummer.im.model.option.FetchStrategy;
import com.hummer.im.model.option.HummerOptions;
import com.hummer.im.model.option.TokenType;
import java.util.HashSet;
import java.util.Set;

public class HummerEvent {
    private static final int EVENT_SDK_INIT = 101;
    private static final int EVENT_LOGOUT = 103;
    private static final int EVENT_REFRESH_TOKEN = 104;
    private static final int EVENT_LOG_TEXT = 105;
    private static final int EVENT_LOG_FILE_PATH = 106;
    private static final int EVENT_SET_LOG_LEVEL = 107;
    private static final int EVENT_LOG_DISABLE_CONSOLE = 108;
    private static final int EVENT_UPLOAD_LOG = 109;
    public static final int EVENT_SET_DEBUG_MODE = 110;
    public static final int EVENT_SET_LOG_CALLBACK = 111;
    public static final int EVENT_SET_FETCH_STRATEGY = 112;
    public static final int EVENT_LOGIN_BYTE = 113;
    private static final int EVENT_SEND_MESSAGE = 201;
    public static final int EVENT_REFRESH_TOKEN_1 = 202;
    private static final int EVENT_REPORT_METRICS_RETURN_CODE = 203;
    private static final int EVENT_SEND_MESSAGE_WITH_OPTIONS = 204;
    public static final int EVENT_REFRESH_BYTE_TOKEN_1 = 205;
    private static final int EVENT_SEND_P2P_MESSAGE = 250;
    private static final int EVENT_FETCH_USER_ONLINE_STATUS = 251;

    public static class EventFetchUserOnlineStatus
    extends EventBase {
        private long requestId;
        private Set<User> users;

        public EventFetchUserOnlineStatus(long requestId, Set<User> users) {
            this.event = 251;
            this.requestId = requestId;
            this.users = users;
        }

        @Override
        public byte[] marshall() {
            if (this.users == null) {
                this.users = new HashSet<User>();
            }
            this.pushInt64(this.requestId);
            this.pushInt(this.users.size());
            for (User user : this.users) {
                this.pushInt64(user.getId());
            }
            return super.marshall();
        }
    }

    public static class EventSentP2PMessage
    extends EventBase {
        private long requestId;
        private User receiver;
        private P2PMessageOptions options;
        private BaseMessage message;

        public EventSentP2PMessage(long requestId, User receiver, P2PMessageOptions options, BaseMessage message) {
            this.event = 250;
            this.requestId = requestId;
            this.receiver = receiver;
            this.options = options;
            this.message = message;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushInt64(this.receiver == null ? 0L : this.receiver.getId());
            this.pushBool(this.options != null && this.options.getOffline());
            this.pushString16(this.message.getUuid());
            this.pushInt64(this.message.getTimestamp());
            this.pushInt(this.message.getMessageType().getType());
            this.pushMap(this.message.getExtra(), String.class);
            if (this.message instanceof TextMessage) {
                this.pushString32(((TextMessage)this.message).getText(), "UTF-8");
            }
            return super.marshall();
        }
    }

    public static class EventReportReturnCode
    extends EventBase {
        private String funcName;
        private long rtt;
        private int code;

        EventReportReturnCode(String funcName, long rtt, int code) {
            this.event = 203;
            this.funcName = funcName;
            this.rtt = rtt;
            this.code = code;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.funcName);
            this.pushInt64(this.rtt);
            this.pushInt(this.code);
            return super.marshall();
        }
    }

    public static class EventSendMessageWithOptions
    extends EventBase {
        private long requestId;
        private Message message;
        private MessageOptions options;

        EventSendMessageWithOptions(long requestId, Message message, MessageOptions options) {
            this.event = 204;
            this.requestId = requestId;
            this.message = message;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushString16(this.message.getUuid());
            if (this.message.getContent() instanceof Text) {
                this.pushInt(0);
                this.pushString32(((Text)this.message.getContent()).getText(), "UTF-8");
            } else if (this.message.getContent() instanceof Image) {
                this.pushInt(1);
                Image image = (Image)this.message.getContent();
                this.pushString16(image.getOriginUrl());
                this.pushInt(image.getWidth());
                this.pushInt(image.getHeight());
            } else if (this.message.getContent() instanceof Audio) {
                this.pushInt(3);
                Audio audio = (Audio)this.message.getContent();
                this.pushString16(audio.getUrl());
                this.pushInt(audio.getDuration());
            } else if (this.message.getContent() instanceof Video) {
                this.pushInt(4);
                Video video = (Video)this.message.getContent();
                this.pushString16(video.getVideoUrl());
                this.pushInt(video.getVideoSize());
                this.pushInt(video.getVideoWidth());
                this.pushInt(video.getVideoHeight());
                this.pushInt(video.getVideoDuration());
                this.pushString16(video.getCoverUrl());
                this.pushInt(video.getCoverWidth());
                this.pushInt(video.getCoverHeight());
            } else if (this.message.getContent() instanceof CustomContent) {
                this.pushInt(5);
                this.pushBytes32(((CustomContent)this.message.getContent()).getData());
            } else if (this.message.getContent() instanceof AppContent) {
                this.pushInt(((AppContent)this.message.getContent()).getType());
                this.pushBytes32(((AppContent)this.message.getContent()).getData());
            }
            this.pushString16(IDFactory.makeType(this.message.getReceiver()).getType());
            this.pushString32(IDFactory.makeString(this.message.getReceiver()));
            this.pushString16(this.message.getAppExtra());
            this.pushMap(this.message.getKvExtra(), String.class);
            this.pushBool(this.message.getStoreStrategy().isRemoteHistoryMessage());
            this.pushBool(this.message.getStoreStrategy().isLocalHistoryMessage());
            this.pushBool(this.message.getStoreStrategy().isLastMessage());
            this.pushBool(this.message.getStoreStrategy().isUnreadCount());
            if (this.message.getPushContent() != null) {
                this.pushBool(true);
                this.pushString32(this.message.getPushContent().getContent());
                this.pushString32(this.message.getPushContent().getTitle());
                this.pushString32(this.message.getPushContent().getIconUrl());
                this.pushBytes32(this.message.getPushContent().getPayload());
            } else {
                this.pushBool(false);
            }
            return super.marshall();
        }
    }

    public static class EventSendMessage
    extends EventBase {
        private long requestId;
        private ChatServiceImpl.MessagePacket packet;

        EventSendMessage(long requestId, ChatServiceImpl.MessagePacket packet) {
            this.event = 201;
            this.requestId = requestId;
            this.packet = packet != null ? packet : new ChatServiceImpl.MessagePacket();
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushString16(this.packet.getUuid());
            this.pushInt(this.packet.getMsgType());
            this.pushInt64(this.packet.getUserId());
            this.pushInt(this.packet.getRoomId());
            this.pushString32(this.packet.getData(), "utf-8");
            this.pushString16(this.packet.getExtra());
            this.pushMap(this.packet.getKvExtra(), String.class);
            return super.marshall();
        }
    }

    public static class EventRefreshByteToken
    extends EventBase {
        private final long requestId;
        private final byte[] token;
        private final HummerOptions options;

        EventRefreshByteToken(long requestId, byte[] token, HummerOptions options) {
            this.event = 104;
            this.requestId = requestId;
            this.token = token;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushBytes32(this.token);
            if (this.options == null) {
                this.pushInt(TokenType.THIRD_USER_TOKEN.getType());
            } else {
                this.pushInt(this.options.getTokenType().getType());
            }
            return super.marshall();
        }
    }

    public static class EventRefreshToken
    extends EventBase {
        private final long requestId;
        private final String token;
        private final HummerOptions options;

        EventRefreshToken(long requestId, String token, HummerOptions options) {
            this.event = 104;
            this.requestId = requestId;
            this.token = token;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushString16(this.token);
            if (this.options == null) {
                this.pushInt(TokenType.THIRD_USER_TOKEN.getType());
            } else {
                this.pushInt(this.options.getTokenType().getType());
            }
            return super.marshall();
        }
    }

    public static class EventSetFetchStrategy
    extends EventBase {
        private final FetchStrategy strategy;

        public EventSetFetchStrategy(FetchStrategy strategy) {
            this.event = 112;
            this.strategy = strategy;
        }

        @Override
        public byte[] marshall() {
            switch (this.strategy) {
                case CONTINUOUSLY: {
                    this.pushInt(1);
                    break;
                }
                case SKIP_FETCHED: {
                    this.pushInt(2);
                    break;
                }
                case RELOAD_HISTORIES: {
                    this.pushInt(3);
                    break;
                }
                case IGNORE_BEFORE: {
                    this.pushInt(4);
                }
            }
            return super.marshall();
        }
    }

    public static class EventUploadLog
    extends EventBase {
        private String note;

        EventUploadLog(String _note) {
            this.event = 109;
            this.note = _note;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.note);
            return super.marshall();
        }
    }

    public static class EventLogDisableConsole
    extends EventBase {
        private boolean disable;

        EventLogDisableConsole(boolean _disable) {
            this.event = 108;
            this.disable = _disable;
        }

        @Override
        public byte[] marshall() {
            this.pushBool(this.disable);
            return super.marshall();
        }
    }

    public static class EventLogSetLevel
    extends EventBase {
        private int level;

        EventLogSetLevel(int _level) {
            this.event = 107;
            this.level = _level;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            return super.marshall();
        }
    }

    public static class EventLogFilePath
    extends EventBase {
        private String filePath;

        EventLogFilePath(String _filePath) {
            this.event = 106;
            this.filePath = _filePath;
        }

        @Override
        public byte[] marshall() {
            this.pushString16(this.filePath);
            return super.marshall();
        }
    }

    public static class EventLogText
    extends EventBase {
        private int level;
        private int module;
        private String moduleName;
        private String tag;
        private String text;

        EventLogText(int _level, int _module, String _moduleName, String _tag, String _text) {
            this.event = 105;
            this.level = _level;
            this.module = _module;
            this.moduleName = _moduleName;
            this.tag = _tag;
            this.text = _text;
        }

        @Override
        public byte[] marshall() {
            this.pushInt(this.level);
            this.pushInt(this.module);
            this.pushString16(this.moduleName);
            this.pushString16(this.tag);
            this.pushString32(this.text);
            return super.marshall();
        }
    }

    public static class EventLogout
    extends EventBase {
        private long requestId;

        EventLogout(long requestId) {
            this.event = 103;
            this.requestId = requestId;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            return super.marshall();
        }
    }

    public static class EventLoginByte
    extends EventBase {
        private final long requestId;
        private final long uid;
        private final String region;
        private final byte[] token;
        private final HummerOptions options;

        EventLoginByte(long requestId, long uid, String region, byte[] token, HummerOptions options) {
            this.event = 113;
            this.requestId = requestId;
            this.uid = uid;
            this.region = region;
            this.token = token;
            this.options = options;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.requestId);
            this.pushInt64(this.uid);
            this.pushString16(this.region);
            this.pushBytes32(this.token);
            if (this.options == null) {
                this.pushInt(TokenType.THIRD_USER_TOKEN.getType());
            } else {
                this.pushInt(this.options.getTokenType().getType());
            }
            return super.marshall();
        }
    }

    public static class EventInitSdk
    extends EventBase {
        private final long appId;
        private final String appVersion;
        private final boolean isDelegateMode;

        EventInitSdk(long appId, String appVersion, boolean isDelegateMode) {
            this.event = 101;
            this.appId = appId;
            this.appVersion = appVersion;
            this.isDelegateMode = isDelegateMode;
        }

        @Override
        public byte[] marshall() {
            this.pushInt64(this.appId);
            this.pushString16(this.appVersion);
            this.pushBool(this.isDelegateMode);
            return super.marshall();
        }
    }

    public static class EventBase
    extends HPMarshaller {
        public int event = 0;

        public int event() {
            return this.event;
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }
    }
}

