/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerEvent;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.HummerLog;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRCompletionArg;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.auth.TokenProvider;
import com.hummer.im.model.id.User;
import com.hummer.im.model.message.BaseMessage;
import com.hummer.im.model.message.P2PMessageOptions;
import com.hummer.im.model.message.TextMessage;
import com.hummer.im.model.option.HummerOptions;
import com.hummer.im.model.user.UserOnlineStatus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class HummerEngine
implements HummerNative.NotificationListener {
    private static HummerEngine INSTANCE = null;
    private static HummerOptions hummerOptions = new HummerOptions();
    private static boolean mIsInited = false;
    private static TokenProvider mTokenProvider = null;
    private static final CopyOnWriteArraySet<HMR.TokenInvalidListener> mTokenInvalidListeners = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<HMR.HummerListener> mHummerListeners = new CopyOnWriteArraySet();
    private static final CopyOnWriteArraySet<KickOutHandler> mKickOutHandler = new CopyOnWriteArraySet();
    private static Map<RequestId, HMRCompletion> mLoginCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static Map<RequestId, HMRCompletion> mLogoutCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static Map<RequestId, HMRCompletion> mRefreshTokenCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static final Map<RequestId, HMRCompletion> HUMMER_ENGINE_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static final Map<RequestId, HMRCompletionArg<Set<UserOnlineStatus>>> FETCH_USER_ONLINE_STATUS_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletionArg<Set<UserOnlineStatus>>>();
    private static final String TAG = "HummerEngine";

    private HummerEngine() {
        HummerNative.registerNotificationListener(this);
    }

    public static synchronized HummerEngine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HummerEngine();
        }
        return INSTANCE;
    }

    public void init(long appId) {
        this.init(appId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long appId, Boolean isDelegateMode) {
        HummerEngine hummerEngine = this;
        synchronized (hummerEngine) {
            if (!mIsInited) {
                Log.setLogger(HummerLog.instance());
                HummerLog.instance().enableConsoleLogger(false);
                long ret = HummerNative.init(appId, "", isDelegateMode == null ? hummerOptions.getIsDelegateMode() : isDelegateMode.booleanValue());
                Log.i(TAG, "createRtcEngine | init end");
                if (ret < 0L) {
                    Log.e(TAG, "createRtcEngine | init failed");
                    return;
                }
                mIsInited = true;
            }
        }
    }

    public void reportReturnCode(String function, long rtt, int code) {
        HummerNative.reportReturnCode(function, rtt, code);
    }

    @Override
    public void handleNotify(int type, byte[] data) {
        Log.i(TAG, "handleNotify | type: " + type);
        try {
            switch (type) {
                case 100: {
                    this.handleHummerStateChanged(data);
                    break;
                }
                case 101: {
                    NotifyHummerKicked base = new NotifyHummerKicked();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerKicked notify = (HummerNotification.HummerKicked)base.get();
                    this.handleHummerKicked(notify.getCode(), notify.getDescription());
                    break;
                }
                case 102: {
                    NotifyHummerKicked base = new NotifyHummerKicked();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerKicked notify = (HummerNotification.HummerKicked)base.get();
                    this.handleTokenExpired(new Error(notify.getCode(), notify.getDescription()));
                    break;
                }
                case 103: {
                    if (mLoginCompletions.isEmpty()) break;
                    NotifyHummerLogin base = new NotifyHummerLogin();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerLogin notify = (HummerNotification.HummerLogin)base.get();
                    RequestId requestId = new RequestId(notify.getRequestId());
                    HMRCompletion completion = mLoginCompletions.remove(requestId);
                    HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
                    break;
                }
                case 104: {
                    this.handleRefreshTokenCallback(data);
                    break;
                }
                case 105: {
                    if (mLogoutCompletions.isEmpty()) break;
                    NotifyHummerLogout base = new NotifyHummerLogout();
                    ((Marshallable)base).unmarshall(data);
                    HummerNotification.HummerLogout notify = (HummerNotification.HummerLogout)base.get();
                    RequestId requestId = new RequestId(notify.getRequestId());
                    HMRCompletion completion = mLogoutCompletions.remove(requestId);
                    HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
                    break;
                }
                case 106: {
                    this.handleRefreshToken1Callback(data);
                    break;
                }
                case 107: {
                    this.handleTokenWillExpired(data);
                    break;
                }
                case 160: {
                    this.handleOnSendP2PMessage(data);
                    break;
                }
                case 161: {
                    this.handleFetchUserOnlineStatus(data);
                    break;
                }
                case 186: {
                    this.handleOnP2PMessageReceived(data);
                    break;
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "handleNotify | type: " + type + ", err: " + e.getMessage());
        }
    }

    private void notifyPreviousTokenExpired(final Error error) {
        Log.i(TAG, "notifyPreviousTokenExpired, errCode: " + error.code);
        if (error.code == ErrorEnum.EXPIRED_TOKEN_EXCEPTION.getCode()) {
            HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visit() {
                    CopyOnWriteArraySet copyOnWriteArraySet = mTokenInvalidListeners;
                    synchronized (copyOnWriteArraySet) {
                        for (HMR.TokenInvalidListener l : mTokenInvalidListeners) {
                            l.onHummerTokenInvalid(HMR.TokenInvalidCode.EXPIRED, error.desc);
                            l.onHummerPreviousTokenExpired();
                        }
                    }
                }
            });
        }
    }

    private void handleHummerStateChanged(byte[] data) {
        NotifyHummerStateChanged base = new NotifyHummerStateChanged();
        base.unmarshall(data);
        final HummerNotification.HummerStateChanged notify = (HummerNotification.HummerStateChanged)base.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                CopyOnWriteArraySet copyOnWriteArraySet = mHummerListeners;
                synchronized (copyOnWriteArraySet) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        HMR.ConnectionState oldState = HMR.ConnectionState.values()[notify.getOldState()];
                        HMR.ConnectionState newState = HMR.ConnectionState.values()[notify.getNewState()];
                        l.onConnectionStateChanged(oldState, newState, notify.getReason());
                    }
                }
            }
        });
    }

    private void handleTokenExpired(Error err) {
        if (mTokenProvider != null) {
            byte[] token = mTokenProvider.getToken(HMR.getMe().getId());
            if (token != null && token.length > 0) {
                HummerEngine.refreshToken1(new String(token), new HMR.Completion(){

                    @Override
                    public void onSuccess() {
                        Log.i(HummerEngine.TAG, "refreshToken1 succeed by tokenProvider!");
                    }

                    @Override
                    public void onFailed(Error err) {
                        HummerEngine.this.notifyPreviousTokenExpired(err);
                    }
                });
            } else {
                Log.e(TAG, "getToken is invalid by tokenProvider!");
                this.notifyPreviousTokenExpired(err);
            }
        } else {
            this.notifyPreviousTokenExpired(err);
        }
    }

    private void handleRefreshTokenCallback(byte[] data) {
        if (!mRefreshTokenCompletions.isEmpty()) {
            NotifyHummerRefreshToken base = new NotifyHummerRefreshToken();
            ((Marshallable)base).unmarshall(data);
            HummerNotification.HummerRefreshToken notify = (HummerNotification.HummerRefreshToken)base.get();
            RequestId requestId = new RequestId(notify.getRequestId());
            HMRCompletion completion = mRefreshTokenCompletions.remove(requestId);
            HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
        }
    }

    private void handleRefreshToken1Callback(byte[] data) {
        if (!mRefreshTokenCompletions.isEmpty()) {
            NotifyHummerRefreshToken base = new NotifyHummerRefreshToken();
            ((Marshallable)base).unmarshall(data);
            HummerNotification.HummerRefreshToken notify = (HummerNotification.HummerRefreshToken)base.get();
            RequestId requestId = new RequestId(notify.getRequestId());
            HMRCompletion completion = mRefreshTokenCompletions.remove(requestId);
            HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc());
        }
    }

    private void handleTokenWillExpired(byte[] data) {
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                CopyOnWriteArraySet copyOnWriteArraySet = mHummerListeners;
                synchronized (copyOnWriteArraySet) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        l.onHummerTokenWillExpired();
                    }
                }
            }
        });
    }

    private void handleOnSendP2PMessage(byte[] data) {
        HummerNotification.NotifyBaseCallback notify = new HummerNotification.NotifyBaseCallback();
        notify.unmarshall(data);
        HummerNotification.BaseCallback callback = (HummerNotification.BaseCallback)notify.get();
        RequestId requestId = new RequestId(callback.getRequestId());
        HMRCompletion completion = HUMMER_ENGINE_COMPLETIONS.remove(requestId);
        HummerDispatch.dispatchCompletion(completion, callback.getCode(), callback.getDesc());
        this.reportReturnCode("HMRSendP2PMessage", callback.getRequestId(), callback.getCode());
    }

    private void handleFetchUserOnlineStatus(byte[] data) {
        HummerNotification.NotifyOnFetchUserOnlineStatus notify = new HummerNotification.NotifyOnFetchUserOnlineStatus();
        notify.unmarshall(data);
        HummerNotification.OnFetchUserOnlineStatus result = (HummerNotification.OnFetchUserOnlineStatus)notify.get();
        RequestId requestId = new RequestId(result.getRequestId());
        HMRCompletionArg<Set<UserOnlineStatus>> completion = FETCH_USER_ONLINE_STATUS_COMPLETIONS.remove(requestId);
        HummerDispatch.dispatchCompletion(completion, result.getStatus(), result.getCode(), result.getDesc());
        this.reportReturnCode("HMRFetchUserOnlineStatus", result.getRequestId(), result.getCode());
    }

    private void handleOnP2PMessageReceived(byte[] data) {
        HummerNotification.NotifyOnP2PMessageReceived notify = new HummerNotification.NotifyOnP2PMessageReceived();
        notify.unmarshall(data);
        final HummerNotification.OnP2PMessageReceived received = (HummerNotification.OnP2PMessageReceived)notify.get();
        if (received.getBaseMessage() == null) {
            Log.e(TAG, "handleOnP2PMessageReceived | message is null");
            return;
        }
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                CopyOnWriteArraySet copyOnWriteArraySet = mHummerListeners;
                synchronized (copyOnWriteArraySet) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        if (!(received.getBaseMessage() instanceof TextMessage)) continue;
                        l.onP2PTextMessageReceived(received.getUser(), (TextMessage)received.getBaseMessage());
                    }
                }
            }
        });
    }

    public void handleLogCallback(final byte[] data) {
        HummerDispatch.runLogDirectAction(new HummerDispatch.RunOutActionVisitor(){

            @Override
            public void visit() {
                NotifyHummerLogCallback base = new NotifyHummerLogCallback();
                ((Marshallable)base).unmarshall(data);
                HummerNotification.HummerLogCallback notify = (HummerNotification.HummerLogCallback)base.get();
                HummerLog.instance().logCallback(notify.getLevel(), notify.getLog());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHummerKicked(final int code, final String reason) {
        CopyOnWriteArraySet<KickOutHandler> copyOnWriteArraySet = mKickOutHandler;
        synchronized (copyOnWriteArraySet) {
            for (KickOutHandler l : mKickOutHandler) {
                l.onHummerKickedResult(new Error(code, reason));
            }
        }
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                CopyOnWriteArraySet copyOnWriteArraySet = mHummerListeners;
                synchronized (copyOnWriteArraySet) {
                    for (HMR.HummerListener l : mHummerListeners) {
                        l.onForceoutOffline(code, reason);
                    }
                }
            }
        });
    }

    public static long login(RequestId requestId, long uid, String region, byte[] token, HMR.Completion completion) {
        HMRCompletion c = new HMRCompletion(requestId, completion);
        if (HMR.getState() == HMR.State.Closing || HMR.getState() == HMR.State.Closed || !HMRContext.isCurrentContext(requestId)) {
            Log.i(TAG, Trace.method("login2").msg("Terminal by logout").info("state", (Object)HMR.getState()).info("currentContext", HMRContext.contextId == null ? 0L : HMRContext.contextId.getId()).info("requestId", requestId.getId()));
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.BAD_USER_ERROR, "Terminal by logout"));
            return 0L;
        }
        mLoginCompletions.put(requestId, c);
        return HummerNative.login(requestId.getId(), uid, region, token, hummerOptions);
    }

    public static long logout(RequestId requestId, HMR.Completion completion) {
        HMRCompletion c = new HMRCompletion(requestId, completion);
        mLogoutCompletions.put(requestId, c);
        return HummerNative.logout(requestId.getId());
    }

    public static String getSdkVersion() {
        return HummerNative.getSdkVersion();
    }

    public static String makeUUID() {
        return HummerNative.makeUUID();
    }

    public static long getSyncTs() {
        return HummerNative.getSyncTs();
    }

    public static HMR.ConnectionState getConnectionState() {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        int state = HummerNative.getState(requestId.getId());
        return HMR.ConnectionState.values()[state];
    }

    public static long refreshToken(String token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        if (completion != null) {
            HMRCompletion c = new HMRCompletion(requestId, completion);
            mRefreshTokenCompletions.put(requestId, c);
        }
        return HummerNative.refreshToken(requestId.getId(), token, hummerOptions);
    }

    public static long refreshToken1(String token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        if (completion != null) {
            HMRCompletion c = new HMRCompletion(requestId, completion);
            mRefreshTokenCompletions.put(requestId, c);
        }
        return HummerNative.refreshToken1(requestId.getId(), token, hummerOptions);
    }

    public static long refreshToken1(byte[] token, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        if (completion != null) {
            HMRCompletion c = new HMRCompletion(requestId, completion);
            mRefreshTokenCompletions.put(requestId, c);
        }
        return HummerNative.refreshToken1(requestId.getId(), token, hummerOptions);
    }

    public static TextMessage createTextMessage(String text) {
        return HummerNative.nativeCreateTextMessage(text);
    }

    public static void sendP2PMessage(User receiver, BaseMessage message, P2PMessageOptions options, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion c = new HMRCompletion(requestId, completion);
        if (receiver == null || receiver.getId() < 0L) {
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Uid"));
            return;
        }
        if (completion != null) {
            HUMMER_ENGINE_COMPLETIONS.put(requestId, c);
        }
        HummerNative.sdkProcess(new HummerEvent.EventSentP2PMessage(requestId.getId(), receiver, options, message));
    }

    public static void fetchUserOnlineStatus(Set<User> users, HMR.CompletionArg<Set<UserOnlineStatus>> completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletionArg<Set<UserOnlineStatus>> c = new HMRCompletionArg<Set<UserOnlineStatus>>(requestId, completion);
        for (User user : users) {
            if (user != null && user.getId() >= 0L) continue;
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Uid"));
            return;
        }
        if (completion != null) {
            FETCH_USER_ONLINE_STATUS_COMPLETIONS.put(requestId, c);
        }
        HummerNative.sdkProcess(new HummerEvent.EventFetchUserOnlineStatus(requestId.getId(), users));
    }

    public static void setTokenProvider(TokenProvider provider) {
        mTokenProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTokenInvalidListener(HMR.TokenInvalidListener listener) {
        if (listener != null) {
            CopyOnWriteArraySet<HMR.TokenInvalidListener> copyOnWriteArraySet = mTokenInvalidListeners;
            synchronized (copyOnWriteArraySet) {
                mTokenInvalidListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTokenInvalidListener(HMR.TokenInvalidListener listener) {
        if (listener != null) {
            CopyOnWriteArraySet<HMR.TokenInvalidListener> copyOnWriteArraySet = mTokenInvalidListeners;
            synchronized (copyOnWriteArraySet) {
                mTokenInvalidListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHummerListener(HMR.HummerListener listener) {
        if (listener != null) {
            CopyOnWriteArraySet<HMR.HummerListener> copyOnWriteArraySet = mHummerListeners;
            synchronized (copyOnWriteArraySet) {
                mHummerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHummerListener(HMR.HummerListener listener) {
        if (listener != null) {
            CopyOnWriteArraySet<HMR.HummerListener> copyOnWriteArraySet = mHummerListeners;
            synchronized (copyOnWriteArraySet) {
                mHummerListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKickOutHandler(KickOutHandler handler) {
        if (handler != null) {
            CopyOnWriteArraySet<KickOutHandler> copyOnWriteArraySet = mKickOutHandler;
            synchronized (copyOnWriteArraySet) {
                mKickOutHandler.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeKickOutHandler(KickOutHandler handler) {
        if (handler != null) {
            CopyOnWriteArraySet<KickOutHandler> copyOnWriteArraySet = mKickOutHandler;
            synchronized (copyOnWriteArraySet) {
                mKickOutHandler.remove(handler);
            }
        }
    }

    public static void setHummerOptions(HummerOptions options) {
        hummerOptions = options;
        if (options != null && options.getFetchStrategy() != null) {
            HummerNative.setFetchStrategy(options.getFetchStrategy());
        }
    }

    public static interface KickOutHandler {
        public void onHummerKickedResult(Error var1);
    }

    private class NotifyReport
    extends NotifyBase {
        private NotifyReport() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.Report(this.popString16UTF8(), this.popMap(String.class, String.class));
        }
    }

    private class NotifyReportMetricsReturnCode
    extends NotifyBase {
        private NotifyReportMetricsReturnCode() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportMetricsReturnCode(this.popInt(), this.popString16UTF8(), this.popInt64(), this.popString16UTF8());
        }
    }

    private class NotifyReportArea
    extends NotifyBase {
        private NotifyReportArea() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportArea(this.popInt());
        }
    }

    private class NotifyReportInit
    extends NotifyBase {
        private NotifyReportInit() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.ReportInit(this.popString16UTF8(), this.popString16UTF8(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogCallback
    extends NotifyBase {
        private NotifyHummerLogCallback() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogCallback(this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogout
    extends NotifyBase {
        private NotifyHummerLogout() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogout(this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerRefreshToken
    extends NotifyBase {
        private NotifyHummerRefreshToken() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerRefreshToken(this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerLogin
    extends NotifyBase {
        private NotifyHummerLogin() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerLogin(this.popInt64(), this.popInt64(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerKicked
    extends NotifyBase {
        private NotifyHummerKicked() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerKicked(this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyHummerStateChanged
    extends NotifyBase {
        private NotifyHummerStateChanged() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.notification = new HummerNotification.HummerStateChanged(this.popInt(), this.popInt(), this.popString16UTF8());
        }
    }

    private class NotifyBase
    extends Marshallable {
        Object notification;

        private NotifyBase() {
        }

        public Object get() {
            return this.notification;
        }
    }
}

