/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.bridge.helper;

import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im.model.id.User;
import java.util.ArrayList;
import java.util.List;

public class BlacklistNotification {
    public static final int CALLBACK_ON_LIST_BLACKLIST = 901;
    public static final int CALLBACK_ON_IS_USER_BLOCKED = 902;
    public static final int CALLBACK_ON_BLOCK_USER = 903;
    public static final int CALLBACK_ON_UNBLOCK_USER = 904;
    public static final int NOTIFY_ON_BLOCK_USER = 961;
    public static final int NOTIFY_ON_UNBLOCK_USER = 962;
    public static final int NOTIFY_ON_BLOCKED_BY_USER = 963;
    public static final int NOTIFY_ON_UNBLOCKED_BY_USER = 964;

    public static class NotifyOnBlockUser
    extends HummerNotification.NotifyBase<OnBlockUser> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            User user = new User(this.popInt64());
            this.setNotification(new OnBlockUser(user));
        }
    }

    public static class OnBlockUser {
        private final User user;

        public OnBlockUser(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }
    }

    public static class CallbackOnIsUserBlocked
    extends HummerNotification.NotifyBase<OnIsUserBlocked> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            int code = this.popInt();
            String desc = this.popString16UTF8();
            User user = new User(this.popInt64());
            boolean isBlock = this.popBool();
            this.setNotification(new OnIsUserBlocked(requestId, code, desc, user, isBlock));
        }
    }

    public static class OnIsUserBlocked
    extends HummerNotification.BaseCallback {
        private final User user;
        private final boolean isBlock;

        public OnIsUserBlocked(long requestId, int code, String desc, User user, boolean isBlock) {
            super(requestId, code, desc);
            this.user = user;
            this.isBlock = isBlock;
        }

        public User getUser() {
            return this.user;
        }

        public boolean getIsBlock() {
            return this.isBlock;
        }
    }

    public static class CallbackOnListBlacklist
    extends HummerNotification.NotifyBase<OnListBlacklist> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            int code = this.popInt();
            String desc = this.popString16UTF8();
            ArrayList<User> users = new ArrayList<User>();
            int size = this.popInt();
            for (int i = 0; i < size; ++i) {
                users.add(new User(this.popInt64()));
            }
            this.setNotification(new OnListBlacklist(requestId, code, desc, users));
        }
    }

    public static class OnListBlacklist
    extends HummerNotification.BaseCallback {
        private final List<User> users;

        public OnListBlacklist(long requestId, int code, String desc, List<User> users) {
            super(requestId, code, desc);
            this.users = users;
        }

        public List<User> getUsers() {
            return this.users;
        }
    }
}

