/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import com.hummer.im._internals.BlacklistServiceImpl;
import com.hummer.im._internals.ChannelStateServiceImpl;
import com.hummer.im._internals.ChatServiceImpl;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.IDType;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.BlacklistService;
import com.hummer.im.service.ChannelStateService;
import com.hummer.im.service.ChatService;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SPCoreModuleLoader
implements ServiceProvider.ModuleLoader {
    @Override
    public void initModule() {
        SPCoreModuleLoader.registerIdExtension();
    }

    @Override
    public void deInitModule() {
    }

    @Override
    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>(){
            {
                this.put(ChatService.class, new ChatServiceImpl());
                this.put(ChannelStateService.class, new ChannelStateServiceImpl());
                this.put(BlacklistService.class, new BlacklistServiceImpl());
            }
        };
    }

    private static void registerIdExtension() {
        IDFactory.registerExtension(new IDFactory.Extension(){

            @Override
            public Identifiable makeId(String idString) {
                if (idString.matches("^user_\\d+$")) {
                    return new User(Long.parseLong(idString.substring(5)));
                }
                if (idString.matches("^group_\\d+$")) {
                    return new Group(Long.parseLong(idString.substring(6)));
                }
                if (idString.contains("app_")) {
                    String[] parts = idString.split("_");
                    if (parts.length < 2) {
                        Log.e("SPCoreModuleLoader", Trace.method("IDFactory.Extension").msg("AppSession").info("error", "[Format error]: format should be app_xxx"));
                        return null;
                    }
                    long idValue = Long.parseLong(parts[1]);
                    String typeValue = parts[2];
                    return new AppSession(typeValue, idValue, null);
                }
                return null;
            }

            @Override
            public String makeString(Identifiable id) {
                if (id instanceof User) {
                    return String.format(Locale.US, "%s_%d", "user", id.getId());
                }
                if (id instanceof Group) {
                    return String.format(Locale.US, "%s_%d", "group", id.getId());
                }
                if (id instanceof AppSession) {
                    return String.format(Locale.US, "%s_%d_%s", "app", id.getId(), ((AppSession)id).getType());
                }
                return null;
            }

            @Override
            public IDType makeType(Identifiable id) {
                if (id instanceof User) {
                    return IDType.USER;
                }
                if (id instanceof Group) {
                    return IDType.GROUP;
                }
                if (id instanceof AppSession) {
                    return IDType.APP_SESSION;
                }
                return null;
            }
        });
    }
}

