/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.bridge.marshall.Marshallable;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.chat.AppContent;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.MessageOptions;
import com.hummer.im.model.chat.contents.Audio;
import com.hummer.im.model.chat.contents.CustomContent;
import com.hummer.im.model.chat.contents.Image;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.chat.contents.Video;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.store.MessageStoreStrategy;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.IDType;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.ChatService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class ChatServiceImpl
implements ChatService,
ServiceProvider.Service,
HummerNative.NotificationListener {
    public static final String CHAT_ROOM_SENDER_PREFIX = "user_";
    public static final String CHAT_ROOM_RECEIVER_PREFIX = "chatroom_";
    public static final String CHAT_ROOM_USER_RECEIVER_PREFIX = "chatroom_/user_";
    public static final String MSG_TYPE_CHAT_ROOM_SIGNAL = "hmr_chatRoom_signal/";
    public static final String MSG_TYPE_CHAT_ROOM_TEXT = "hmr_text/";
    private static final String TAG = "ChatServiceImpl";
    private final Map<String, HashSet<ChatService.MessageListener>> mMessageListeners = new HashMap<String, HashSet<ChatService.MessageListener>>();
    private final Map<String, HashSet<ChatService.StateListener>> mStateListeners = new HashMap<String, HashSet<ChatService.StateListener>>();
    private static final Set<ChatService.MessageServiceListener> MESSAGE_SERVICE_LISTENERS = new CopyOnWriteArraySet<ChatService.MessageServiceListener>();
    private static final String DEFAULT_STATE_LISTENER_KEY = "default_state_listener_key";
    private static final String DEFAULT_MESSAGE_LISTENER_KEY = "default_message_listener_key";
    private static final Map<RequestId, HMRCompletion> mSendMessageCompletions = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static final Map<RequestId, HMRCompletion> CHAT_SERVICE_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static List<SendingExtension> sendingExtensions = new ArrayList<SendingExtension>();

    private static void registerChatContentCodes() {
        Text.registerCodecs();
        Image.registerCodecs();
        Audio.registerCodecs();
        Video.registerCodecs();
        CustomContent.registerCodecs();
    }

    public static void registerSendingExtension(SendingExtension ext) {
        sendingExtensions.add(ext);
    }

    private static MessagePacket makeSendMessage(Message message) {
        for (SendingExtension ext : sendingExtensions) {
            MessagePacket messageContent = ext.makeMessagePacket(message);
            if (messageContent == null) continue;
            return messageContent;
        }
        return null;
    }

    private static boolean completionMessage(Message message, int msgType, long userId, long roomId, String data) {
        for (SendingExtension ext : sendingExtensions) {
            if (!ext.parseMessage(message, msgType, userId, roomId, data)) continue;
            return true;
        }
        return false;
    }

    private String makeChatRoomUser(long uid) {
        return CHAT_ROOM_USER_RECEIVER_PREFIX + uid;
    }

    private String makeChatRoom(long roomId) {
        return CHAT_ROOM_RECEIVER_PREFIX + roomId;
    }

    private long ExtractUserId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_SENDER_PREFIX);
    }

    private long ExtractChatRoomId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_RECEIVER_PREFIX);
    }

    private long extractChatRoomUserId(String userId) {
        return this.extractUserPrefix(userId, CHAT_ROOM_USER_RECEIVER_PREFIX);
    }

    private long extractUserPrefix(String userId, String prefix) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return 0L;
        }
        String idStr = userId.replace(prefix, "");
        long id = 0L;
        try {
            id = Long.valueOf(idStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id;
    }

    @Override
    public void handleNotify(final int type, byte[] data) {
        Log.i(TAG, "handleNotify | type: " + type);
        try {
            if (type == 301) {
                NotifyOnSendMessage base = new NotifyOnSendMessage();
                ((Marshallable)base).unmarshall(data);
                HummerNotification.OnSendMessage notify = (HummerNotification.OnSendMessage)base.get();
                RequestId requestId = new RequestId(notify.getRequestId());
                HMRCompletion completion = mSendMessageCompletions.remove(requestId);
                HummerDispatch.dispatchCompletion(completion, notify.getCode(), notify.getDesc(), notify.getExtraInfo());
            } else if (type >= 302 && type <= 306) {
                NotifyOnMessage base = new NotifyOnMessage();
                ((Marshallable)base).unmarshall(data);
                final HummerNotification.OnMessage notify = (HummerNotification.OnMessage)base.get();
                boolean result = ChatServiceImpl.completionMessage(notify.getMessage(), notify.getMsgType(), notify.getUserId(), notify.getRoomId(), notify.getData());
                if (result) {
                    final Message message = notify.getMessage();
                    HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void visit() {
                            if (type == 306) {
                                ChatServiceImpl.this.notifyMessageStateChange(message);
                            } else {
                                Object object = ChatServiceImpl.this.mMessageListeners;
                                synchronized (object) {
                                    String key = String.valueOf(message.getTarget() == null ? "" : Long.valueOf(message.getTarget().getId()));
                                    HashSet listeners = (HashSet)ChatServiceImpl.this.mMessageListeners.get(key);
                                    HashSet hashLis = listeners == null ? new HashSet() : (HashSet)listeners.clone();
                                    HashSet fullListeners = (HashSet)ChatServiceImpl.this.mMessageListeners.get(ChatServiceImpl.DEFAULT_MESSAGE_LISTENER_KEY);
                                    if (fullListeners != null) {
                                        hashLis.addAll((HashSet)fullListeners.clone());
                                    }
                                    for (ChatService.MessageListener listener : hashLis) {
                                        if (type == 302) {
                                            listener.beforeSendingMessage(notify.getMessage());
                                            continue;
                                        }
                                        if (type == 303) {
                                            listener.afterSendingMessage(notify.getMessage());
                                            continue;
                                        }
                                        if (type == 304) {
                                            listener.beforeReceivingMessage(notify.getMessage());
                                            continue;
                                        }
                                        if (type != 305) continue;
                                        listener.afterReceivingMessage(notify.getMessage());
                                    }
                                }
                                object = MESSAGE_SERVICE_LISTENERS;
                                synchronized (object) {
                                    for (ChatService.MessageServiceListener listener : MESSAGE_SERVICE_LISTENERS) {
                                        if (type != 305) continue;
                                        listener.onMessageReceived(notify.getMessage());
                                    }
                                }
                            }
                        }
                    });
                } else {
                    Log.e(TAG, "handleNotify | completionMessage failed!");
                }
            } else if (type == 307) {
                this.handleOnMessageStateUpdated(data);
            } else if (type == 308) {
                this.handleOnMessagePrepareProgress(data);
            } else if (type == 309) {
                this.handleOnMessageReceived(data);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "handleNotify | type: " + type + ", err: " + e.getMessage());
        }
    }

    private void handleOnMessageStateUpdated(byte[] data) {
        HummerNotification.NotifyOnMessageStateUpdated base = new HummerNotification.NotifyOnMessageStateUpdated();
        base.unmarshall(data);
        final HummerNotification.OnMessageStateUpdated notify = (HummerNotification.OnMessageStateUpdated)base.get();
        final Message.State state = notify.getMessage().getState();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                ChatServiceImpl.this.notifyMessageStateChange(notify.getMessage());
                if (state instanceof Init) {
                    Map map = ChatServiceImpl.this.mMessageListeners;
                    synchronized (map) {
                        for (ChatService.MessageListener listener : ChatServiceImpl.this.getMessageListenerSet(notify.getMessage())) {
                            listener.beforeSendingMessage(notify.getMessage());
                        }
                    }
                }
                if (state instanceof Archived || state instanceof Failed) {
                    Map map = ChatServiceImpl.this.mMessageListeners;
                    synchronized (map) {
                        for (ChatService.MessageListener listener : ChatServiceImpl.this.getMessageListenerSet(notify.getMessage())) {
                            listener.afterSendingMessage(notify.getMessage());
                        }
                    }
                }
            }
        });
        RequestId requestId = new RequestId(notify.getRequestId());
        if (state instanceof Archived) {
            HMRCompletion completion = CHAT_SERVICE_COMPLETIONS.remove(requestId);
            HummerDispatch.dispatchCompletion(completion, ErrorEnum.OK.getCode(), ErrorEnum.OK.getDesc());
        } else if (state instanceof Failed) {
            HMRCompletion completion = CHAT_SERVICE_COMPLETIONS.remove(requestId);
            Failed failed = (Failed)state;
            HummerDispatch.dispatchCompletion(completion, failed.error.code, failed.error.desc, failed.error.extraInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageStateChange(Message message) {
        Object object = this.mStateListeners;
        synchronized (object) {
            HashSet<ChatService.StateListener> fullListeners;
            HashSet<ChatService.StateListener> listeners = this.mStateListeners.get(message.getUuid());
            if (listeners != null) {
                HashSet hashLis = (HashSet)listeners.clone();
                for (ChatService.StateListener l : hashLis) {
                    l.onUpdateMessageState(message, message.getState());
                }
            }
            if ((fullListeners = this.mStateListeners.get(DEFAULT_STATE_LISTENER_KEY)) != null) {
                HashSet hashFullLis = (HashSet)fullListeners.clone();
                for (ChatService.StateListener l : hashFullLis) {
                    l.onUpdateMessageState(message, message.getState());
                }
            }
        }
        object = MESSAGE_SERVICE_LISTENERS;
        synchronized (object) {
            for (ChatService.MessageServiceListener listener : MESSAGE_SERVICE_LISTENERS) {
                listener.onMessageStateUpdated(message);
            }
        }
    }

    private void handleOnMessagePrepareProgress(byte[] data) {
        HummerNotification.NotifyOnMessagePrepareProgress base = new HummerNotification.NotifyOnMessagePrepareProgress();
        base.unmarshall(data);
        final HummerNotification.OnMessagePrepareProgress notify = (HummerNotification.OnMessagePrepareProgress)base.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = MESSAGE_SERVICE_LISTENERS;
                synchronized (set) {
                    for (ChatService.MessageServiceListener listener : MESSAGE_SERVICE_LISTENERS) {
                        listener.onContentProgressUpdated(notify.getMessage());
                    }
                }
            }
        });
    }

    private void handleOnMessageReceived(byte[] data) {
        HummerNotification.NotifyOnMessageReceived base = new HummerNotification.NotifyOnMessageReceived();
        base.unmarshall(data);
        final HummerNotification.OnMessageReceived notify = (HummerNotification.OnMessageReceived)base.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Object object = ChatServiceImpl.this.mMessageListeners;
                synchronized (object) {
                    for (Object listener : ChatServiceImpl.this.getMessageListenerSet(notify.getMessage())) {
                        listener.beforeReceivingMessage(notify.getMessage());
                        listener.afterReceivingMessage(notify.getMessage());
                    }
                }
                object = MESSAGE_SERVICE_LISTENERS;
                synchronized (object) {
                    for (Object listener : MESSAGE_SERVICE_LISTENERS) {
                        listener.onMessageReceived(notify.getMessage());
                    }
                }
            }
        });
    }

    private Set<ChatService.MessageListener> getMessageListenerSet(Message message) {
        String key = String.valueOf(message.getTarget() == null ? "" : Long.valueOf(message.getTarget().getId()));
        HashSet<ChatService.MessageListener> listeners = this.mMessageListeners.get(key);
        HashSet hashLis = listeners == null ? new HashSet() : (HashSet)listeners.clone();
        HashSet<ChatService.MessageListener> fullListeners = this.mMessageListeners.get(DEFAULT_MESSAGE_LISTENER_KEY);
        if (fullListeners != null) {
            hashLis.addAll((HashSet)fullListeners.clone());
        }
        return hashLis;
    }

    @Override
    public void initService() {
        HummerNative.registerNotificationListener(this);
        ChatServiceImpl.registerChatContentCodes();
    }

    @Override
    public void openService(@NonNull HMRCompletion completion) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public int serviceSort() {
        return 0;
    }

    @Override
    public void closeService() {
    }

    @Override
    public void send(@NonNull Message message, @Nullable HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = this.createHMRCompletion(requestId, completion, "HMRSendMessage");
        if (message == null) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "message cannot be null"));
            return;
        }
        this.sendMessage(requestId, message, null, hmrCompletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(@Nullable Identifiable target, @NonNull ChatService.MessageListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
            synchronized (map) {
                HashSet<ChatService.MessageListener> listeners;
                String lisKey = DEFAULT_MESSAGE_LISTENER_KEY;
                if (target != null) {
                    lisKey = String.valueOf(target.getId());
                }
                if ((listeners = this.mMessageListeners.get(lisKey)) == null) {
                    listeners = new HashSet();
                    this.mMessageListeners.put(lisKey, listeners);
                }
                listeners.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddMessageListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(@Nullable Identifiable target, @NonNull ChatService.MessageListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.MessageListener>> map = this.mMessageListeners;
            synchronized (map) {
                HashSet<ChatService.MessageListener> listeners;
                String lisKey = DEFAULT_MESSAGE_LISTENER_KEY;
                if (target != null) {
                    lisKey = String.valueOf(target.getId());
                }
                if ((listeners = this.mMessageListeners.get(lisKey)) != null) {
                    listeners.remove(listener);
                }
            }
        }
        HMRContext.reportReturnCode("HMRRemoveMessageListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(@Nullable Message message, @NonNull ChatService.StateListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
            synchronized (map) {
                HashSet<ChatService.StateListener> listeners;
                String lisKey = DEFAULT_STATE_LISTENER_KEY;
                if (message != null) {
                    lisKey = message.getUuid();
                }
                if ((listeners = this.mStateListeners.get(lisKey)) == null) {
                    listeners = new HashSet();
                    this.mStateListeners.put(lisKey, listeners);
                }
                listeners.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddMessageStateListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(@Nullable Message message, @NonNull ChatService.StateListener listener) {
        if (listener != null) {
            Map<String, HashSet<ChatService.StateListener>> map = this.mStateListeners;
            synchronized (map) {
                HashSet<ChatService.StateListener> listeners;
                String lisKey = DEFAULT_STATE_LISTENER_KEY;
                if (message != null) {
                    lisKey = message.getUuid();
                }
                if ((listeners = this.mStateListeners.get(lisKey)) != null) {
                    listeners.remove(listener);
                }
            }
        }
        HMRContext.reportReturnCode("HMRRemoveMessageStateListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageServiceListener(ChatService.MessageServiceListener listener) {
        if (listener != null) {
            Set<ChatService.MessageServiceListener> set = MESSAGE_SERVICE_LISTENERS;
            synchronized (set) {
                MESSAGE_SERVICE_LISTENERS.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddMessageServiceListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageServiceListener(ChatService.MessageServiceListener listener) {
        if (listener != null) {
            Set<ChatService.MessageServiceListener> set = MESSAGE_SERVICE_LISTENERS;
            synchronized (set) {
                MESSAGE_SERVICE_LISTENERS.remove(listener);
            }
        }
        HMRContext.reportReturnCode("HMRRemoveMessageServiceListener", HMRContext.getCurrentTime());
    }

    @Override
    public Text createText(String text) {
        return new Text(text);
    }

    @Override
    public Image createImage(@NonNull String path, int width, int height) {
        return Image.create(path, width, height);
    }

    @Override
    public Audio createAudio(@NonNull String path, int duration) {
        return Audio.create(path, duration);
    }

    @Override
    public Video createVideo(@NonNull String videoPath, long videoSize, int videoWidth, int videoHeight, int videoDuration, @NonNull String coverPath, int coverWidth, int coverHeight) {
        return Video.create(videoPath, videoSize, videoWidth, videoHeight, videoDuration, coverPath, coverWidth, coverHeight);
    }

    @Override
    public CustomContent createCustomContent(byte[] data) {
        return new CustomContent(data);
    }

    @Override
    public AppContent createAppContent(int type, byte[] data) {
        return new AppContent(type, data);
    }

    @Override
    public Message createMessage(@NonNull Identifiable target, @NonNull Content messageContent) {
        return new Message(target, messageContent);
    }

    @Override
    public Message createMessage(@NonNull Identifiable target, @NonNull Content messageContent, @NonNull MessageStoreStrategy storeStrategy) {
        return new Message(target, messageContent, storeStrategy);
    }

    @Override
    public void sendMessage(@NonNull Message message, MessageOptions options, HMR.Completion completion) {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = this.createHMRCompletion(requestId, completion, "HMRSendMessageWithOptions");
        if (message == null || message.getContent() == null) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "Message Or Content Cannot Be Null"));
            return;
        }
        if (message.getReceiver() == null) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Receiver"));
            return;
        }
        if (message.getStoreStrategy() == null) {
            message.setStoreStrategy(new MessageStoreStrategy());
        }
        this.sendMessage(requestId, message, options, hmrCompletion);
    }

    private void sendMessage(RequestId requestId, Message message, MessageOptions options, HMRCompletion completion) {
        boolean flag = IDType.CHAT_ROOM.equals((Object)IDFactory.makeType(message.getReceiver()));
        if (flag) {
            mSendMessageCompletions.put(requestId, completion);
            MessagePacket packet = ChatServiceImpl.makeSendMessage(message);
            HummerNative.sendMessage(requestId.getId(), packet);
        } else {
            Error error = this.validSendMessage(message);
            if (error != null) {
                CompletionUtils.dispatchFailure(completion, error);
                return;
            }
            CHAT_SERVICE_COMPLETIONS.put(requestId, completion);
            HummerNative.sendMessage(requestId.getId(), message, options);
        }
    }

    private HMRCompletion createHMRCompletion(@NonNull RequestId requestId, final HMR.Completion completion, final String functionName) {
        final long now = HMRContext.getCurrentTime();
        return new HMRCompletion(requestId, new HMR.Completion(){

            @Override
            public void onSuccess() {
                if (completion != null) {
                    completion.onSuccess();
                }
                HMRContext.reportReturnCode(functionName, now);
            }

            @Override
            public void onFailed(Error err) {
                if (completion != null) {
                    completion.onFailed(err);
                }
                HMRContext.reportReturnCode(functionName, now, err);
            }
        });
    }

    private Error validSendMessage(Message message) {
        if (!message.getReceiver().valid()) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Receiver");
        }
        return message.getContent().validContent();
    }

    private class NotifyOnSendMessage
    extends NotifyBase {
        private NotifyOnSendMessage() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = this.popInt64();
            int code = this.popInt();
            String desc = this.popString16UTF8();
            Map<String, String> extraInfo = this.popMap(String.class, String.class);
            int stateType = this.popInt();
            int stateCode = this.popInt();
            String stateDesc = this.popString16UTF8();
            String uuid = this.popString16UTF8();
            long timestamp = this.popInt64();
            String sender = this.popString16UTF8();
            String receiver = this.popString16UTF8();
            String contentData = this.popString32("utf-8");
            String contentReserved = this.popString16();
            String extra = this.popString16();
            Message message = new Message();
            this.notification = new HummerNotification.OnSendMessage(requestId, code, desc, extraInfo, message);
        }
    }

    private class NotifyOnMessage
    extends NotifyBase {
        private NotifyOnMessage() {
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            int stateType = this.popInt();
            int stateCode = this.popInt();
            String stateDesc = this.popString16UTF8();
            Map<String, String> extraInfo = this.popMap(String.class, String.class);
            String uuid = this.popString16UTF8();
            long timestamp = this.popInt64();
            String sender = this.popString16UTF8();
            String receiver = this.popString16UTF8();
            String contentData = this.popString32("utf-8");
            String contentReserved = this.popString16();
            String extra = this.popString16UTF8();
            Map<String, String> kv = this.popMap(String.class, String.class);
            int msgType = this.popInt();
            long userId = this.popInt64();
            long roomId = this.popInt2Long();
            Message message = new Message();
            message.setState(Message.buildSate(stateType, stateCode, stateDesc, extraInfo));
            message.setSender(new User(ChatServiceImpl.this.ExtractUserId(sender)));
            message.setUuid(uuid);
            message.setTimestamp(timestamp);
            message.setAppExtra(extra);
            message.setKvExtra(kv);
            this.notification = new HummerNotification.OnMessage(message, msgType, userId, roomId, contentData);
        }
    }

    private class NotifyBase
    extends Marshallable {
        Object notification;

        private NotifyBase() {
        }

        public Object get() {
            return this.notification;
        }
    }

    public static interface SendingExtension {
        public MessagePacket makeMessagePacket(Message var1);

        public boolean parseMessage(Message var1, int var2, long var3, long var5, String var7);
    }

    public static class MessagePacket {
        public static final int MSG_TYPE_TEXT = 10;
        public static final int MSG_TYPE_BROADCAST = 20;
        public static final int MSG_TYPE_UNICAST = 30;
        private long userId;
        private String uuid;
        private long roomId;
        private int msgType;
        private String data;
        private String extra;
        private Map<String, String> kvExtra;

        public MessagePacket() {
        }

        public MessagePacket(long userId, String uuid, long roomId, int msgType, String data, String extra, Map<String, String> kvExtra) {
            this.userId = userId;
            this.uuid = uuid;
            this.roomId = roomId;
            this.data = data;
            this.msgType = msgType;
            this.extra = extra;
            this.kvExtra = kvExtra;
        }

        public long getUserId() {
            return this.userId;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public long getRoomId() {
            return this.roomId;
        }

        public void setRoomId(long roomId) {
            this.roomId = roomId;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public void setMsgType(int msgType) {
            this.msgType = msgType;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public Map<String, String> getKvExtra() {
            return this.kvExtra;
        }

        public void setKvExtra(Map<String, String> kvExtra) {
            this.kvExtra = kvExtra;
        }
    }
}

