/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.BlacklistNative;
import com.hummer.im._internals.bridge.helper.BlacklistNotification;
import com.hummer.im._internals.bridge.helper.HummerDispatch;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im._internals.bridge.helper.HummerNotification;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRCompletionArg;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.id.User;
import com.hummer.im.service.BlacklistService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class BlacklistServiceImpl
implements BlacklistService,
ServiceProvider.Service,
HummerNative.NotificationListener {
    private static final Set<BlacklistService.BlacklistListener> BLACKLIST_LISTENERS = new CopyOnWriteArraySet<BlacklistService.BlacklistListener>();
    private static final Map<RequestId, HMRCompletion> BLACKLIST_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletion>();
    private static final Map<RequestId, HMRCompletionArg<List<User>>> LIST_BLACKLIST_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletionArg<List<User>>>();
    private static final Map<RequestId, HMRCompletionArg<Boolean>> IS_BLOCKED_COMPLETIONS = new ConcurrentHashMap<RequestId, HMRCompletionArg<Boolean>>();
    private static final String TAG = "BlacklistService";

    @Override
    public void initService() {
        HummerNative.registerNotificationListener(this);
    }

    @Override
    public void openService(@NonNull HMRCompletion completion) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public int serviceSort() {
        return 0;
    }

    @Override
    public void closeService() {
    }

    @Override
    public void listBlacklist(HMR.CompletionArg<List<User>> completion) {
        RequestId requestId = HMRContext.createRequestId();
        HMRCompletionArg<List<User>> c = new HMRCompletionArg<List<User>>(requestId, completion);
        if (completion != null) {
            LIST_BLACKLIST_COMPLETIONS.put(requestId, c);
        }
        BlacklistNative.listBlacklist(requestId.getId());
    }

    @Override
    public void isBlocked(@NonNull User user, HMR.CompletionArg<Boolean> completion) {
        RequestId requestId = HMRContext.createRequestId();
        HMRCompletionArg<Boolean> c = new HMRCompletionArg<Boolean>(requestId, completion);
        if (user == null || user.getId() < 0L) {
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Operated Uid"));
            return;
        }
        if (completion != null) {
            IS_BLOCKED_COMPLETIONS.put(requestId, c);
        }
        BlacklistNative.isBlocked(requestId.getId(), user);
    }

    @Override
    public void block(@NonNull User user, HMR.Completion completion) {
        RequestId requestId = HMRContext.createRequestId();
        HMRCompletion c = new HMRCompletion(requestId, completion);
        if (user == null || user.getId() < 0L) {
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Operated Uid"));
            return;
        }
        if (completion != null) {
            BLACKLIST_COMPLETIONS.put(requestId, c);
        }
        BlacklistNative.block(requestId.getId(), user);
    }

    @Override
    public void unblock(@NonNull User user, HMR.Completion completion) {
        RequestId requestId = HMRContext.createRequestId();
        HMRCompletion c = new HMRCompletion(requestId, completion);
        if (user == null || user.getId() < 0L) {
            CompletionUtils.dispatchFailure(c, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Operated Uid"));
            return;
        }
        if (completion != null) {
            BLACKLIST_COMPLETIONS.put(requestId, c);
        }
        BlacklistNative.unblock(requestId.getId(), user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BlacklistService.BlacklistListener listener) {
        if (listener != null) {
            Set<BlacklistService.BlacklistListener> set = BLACKLIST_LISTENERS;
            synchronized (set) {
                BLACKLIST_LISTENERS.add(listener);
            }
        }
        HMRContext.reportReturnCode("HMRAddBlacklistListener", HMRContext.getCurrentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BlacklistService.BlacklistListener listener) {
        if (listener != null) {
            Set<BlacklistService.BlacklistListener> set = BLACKLIST_LISTENERS;
            synchronized (set) {
                BLACKLIST_LISTENERS.remove(listener);
            }
        }
        HMRContext.reportReturnCode("HMRRemoveBlacklistListener", HMRContext.getCurrentTime());
    }

    @Override
    public void handleNotify(int type, byte[] data) {
        int notifyType = type / 100;
        if (notifyType != 9) {
            return;
        }
        try {
            if (type == 901) {
                this.handleCallbackOnListBlacklist(data);
            } else if (type == 902) {
                this.handleCallbackOnIsUserBlocked(data);
            } else if (type == 903) {
                this.handleCallbackOnBlockUser(data);
            } else if (type == 904) {
                this.handleCallbackOnUnblockUser(data);
            } else if (type == 961) {
                this.handleBlacklistNotification(data, 961);
            } else if (type == 962) {
                this.handleBlacklistNotification(data, 962);
            } else if (type == 963) {
                this.handleBlacklistNotification(data, 963);
            } else if (type == 964) {
                this.handleBlacklistNotification(data, 964);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "handleNotify | type: " + type + ", err: " + e.getMessage());
        }
    }

    private void handleCallbackOnListBlacklist(byte[] data) {
        BlacklistNotification.CallbackOnListBlacklist notify = new BlacklistNotification.CallbackOnListBlacklist();
        notify.unmarshall(data);
        BlacklistNotification.OnListBlacklist callback = (BlacklistNotification.OnListBlacklist)notify.get();
        RequestId requestId = new RequestId(callback.getRequestId());
        HMRCompletionArg<List<User>> completion = LIST_BLACKLIST_COMPLETIONS.remove(requestId);
        HummerDispatch.dispatchCompletion(completion, callback.getUsers(), callback.getCode(), callback.getDesc());
        HMRContext.report("HMRListBlacklist", callback.getRequestId(), callback.getCode());
    }

    private void handleCallbackOnIsUserBlocked(byte[] data) {
        BlacklistNotification.CallbackOnIsUserBlocked notify = new BlacklistNotification.CallbackOnIsUserBlocked();
        notify.unmarshall(data);
        BlacklistNotification.OnIsUserBlocked callback = (BlacklistNotification.OnIsUserBlocked)notify.get();
        RequestId requestId = new RequestId(callback.getRequestId());
        HMRCompletionArg<Boolean> completion = IS_BLOCKED_COMPLETIONS.remove(requestId);
        HummerDispatch.dispatchCompletion(completion, callback.getIsBlock(), callback.getCode(), callback.getDesc());
        HMRContext.report("HMRIsBlocked", callback.getRequestId(), callback.getCode());
    }

    private void handleCallbackOnBlockUser(byte[] data) {
        this.handleBaseCallback(data, "HMRBlock");
    }

    private void handleCallbackOnUnblockUser(byte[] data) {
        this.handleBaseCallback(data, "HMRUnblock");
    }

    private void handleBaseCallback(byte[] data, String functionName) {
        HummerNotification.NotifyBaseCallback notify = new HummerNotification.NotifyBaseCallback();
        notify.unmarshall(data);
        HummerNotification.BaseCallback callback = (HummerNotification.BaseCallback)notify.get();
        RequestId requestId = new RequestId(callback.getRequestId());
        HMRCompletion completion = BLACKLIST_COMPLETIONS.remove(requestId);
        HummerDispatch.dispatchCompletion(completion, callback.getCode(), callback.getDesc());
        HMRContext.report(functionName, callback.getRequestId(), callback.getCode());
    }

    public void handleBlacklistNotification(byte[] data, final int type) {
        BlacklistNotification.NotifyOnBlockUser notify = new BlacklistNotification.NotifyOnBlockUser();
        notify.unmarshall(data);
        final BlacklistNotification.OnBlockUser info = (BlacklistNotification.OnBlockUser)notify.get();
        HummerDispatch.runOutAction(new HummerDispatch.RunOutActionVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit() {
                Set set = BLACKLIST_LISTENERS;
                synchronized (set) {
                    for (BlacklistService.BlacklistListener listener : BLACKLIST_LISTENERS) {
                        if (type == 961) {
                            listener.onBlockUser(info.getUser());
                            continue;
                        }
                        if (type == 962) {
                            listener.onUnblockUser(info.getUser());
                            continue;
                        }
                        if (type == 963) {
                            listener.onBlockedByUser(info.getUser());
                            continue;
                        }
                        if (type != 964) continue;
                        listener.onUnblockedByUser(info.getUser());
                    }
                }
            }
        });
    }
}

