/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im._internals.log.HummerLog;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.CompletionUtils;
import com.hummer.im._internals.utility.DispatchQueue;
import com.hummer.im._internals.utility.HMRCompletion;
import com.hummer.im._internals.utility.HMRContext;
import com.hummer.im._internals.utility.RequestIdBuilder;
import com.hummer.im._internals.utility.ServiceProvider;
import com.hummer.im.model.RequestId;
import com.hummer.im.model.auth.TokenProvider;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.model.message.BaseMessage;
import com.hummer.im.model.message.P2PMessageOptions;
import com.hummer.im.model.message.TextMessage;
import com.hummer.im.model.option.HummerOptions;
import com.hummer.im.model.user.UserOnlineStatus;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class HMR {
    private static final HummerEngine.KickOutHandler KICK_OUT_HANDLER = new HummerEngine.KickOutHandler(){

        @Override
        public void onHummerKickedResult(Error error) {
            HMR.hummerStateToClosed();
        }
    };
    private static final String TAG = "HMR";
    private static State state = State.Unavailable;
    private static TokenProvider mTokenProvider = null;
    private static final CopyOnWriteArraySet<StateListener> mStateListeners = new CopyOnWriteArraySet();
    private static User me = null;

    private HMR() {
    }

    private static boolean isInitialized() {
        return HMRContext.appId != null || state != State.Unavailable;
    }

    @Deprecated
    public static void init(@NonNull Context appContext, long appId, @Nullable TokenProvider provider) {
        long now = HMRContext.getCurrentTime();
        if (HMR.isInitialized()) {
            Log.e(TAG, Trace.method("init").info("Hummer already been initialized!", ""));
            return;
        }
        HMRContext.appId = appId;
        HMRContext.appContext = new WeakReference<Context>(appContext.getApplicationContext());
        HummerEngine.getInstance().init(appId, provider == null);
        mTokenProvider = provider;
        HummerEngine.setTokenProvider(provider);
        ServiceProvider.loadServicesIfNeeded("com.hummer.im");
        HMR.setHummerState(State.Closed);
        HMRContext.reportReturnCode("HMRInitWithTokenProvider", now);
    }

    public static void init(@NonNull Context appContext, long appId) {
        Log.i(TAG, "[start] init appId: " + appId);
        long now = HMRContext.getCurrentTime();
        if (HMR.isInitialized()) {
            Log.e(TAG, Trace.method("init").info("Hummer already been initialized!", ""));
            return;
        }
        HMRContext.appId = appId;
        HMRContext.appContext = new WeakReference<Context>(appContext.getApplicationContext());
        HummerEngine.getInstance().init(appId);
        ServiceProvider.loadServicesIfNeeded("com.hummer.im");
        HMR.setHummerState(State.Closed);
        HMRContext.reportReturnCode("HMRInit", now);
        Log.i(TAG, "[end] init appId: " + appId);
    }

    public static void setHummerOptions(@NonNull HummerOptions options) {
        Log.i(TAG, Trace.method("setHummerOptions").msg(options));
        if (options == null) {
            return;
        }
        HummerEngine.setHummerOptions(options);
    }

    @Deprecated
    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @Nullable Completion completion) {
        byte[] bytes;
        String token = "";
        if (mTokenProvider != null && (bytes = mTokenProvider.getToken(uid)) != null && bytes.length > 0) {
            token = new String(bytes);
        }
        HMR.doOpen(uid, region, token.getBytes(), completion, "HMROpen");
    }

    @Deprecated
    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @Nullable TokenProvider provider, @Nullable Completion completion) {
        byte[] bytes;
        HummerEngine.setTokenProvider(provider);
        String token = "";
        if (provider != null && (bytes = provider.getToken(uid)) != null && bytes.length > 0) {
            token = new String(bytes);
        }
        HMR.doOpen(uid, region, token.getBytes(), completion, "HMROpenWithTokenProvider");
    }

    @Deprecated
    public static void open(long uid, @NonNull String region, @Nullable Set<String> tagSet, @NonNull String token, @Nullable Completion completion) {
        HMR.doOpen(uid, region, token.getBytes(), completion, "HMROpenWithToken");
    }

    public static void open(long uid, @NonNull String region, @NonNull String token, @Nullable Completion completion) {
        Log.i(TAG, "HMROpenWithToken open uid: " + uid + ", region: " + region);
        HMR.doOpen(uid, region, token.getBytes(), completion, "HMROpenWithToken");
    }

    private static void doOpenFailed(HMRCompletion completion, String funcName, long now, Error error) {
        HMR.hummerStateToClosed();
        HMRContext.reportReturnCode(funcName, now, error);
        CompletionUtils.dispatchFailure(completion, error);
    }

    public static void open(long uid, @NonNull String region, @NonNull byte[] token, @Nullable Completion completion) {
        Log.i(TAG, "HMROpenWithByteToken open uid: " + uid + ", region: " + region + ", token size: " + token.length);
        HMR.doOpen(uid, region, token, completion, "HMROpenWithByteToken");
    }

    private static void doOpen(final long uid, final String region, final byte[] token, Completion completion, final String funcName) {
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        Log.i(TAG, Trace.method("open").msg("open sdk").info("uid", uid).info("rid", requestId.getId()));
        final HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        HMRContext.work.async(new Runnable(){

            @Override
            public void run() {
                if (!HMR.isInitialized()) {
                    CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
                    return;
                }
                if (uid < 0L) {
                    CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Uid"));
                    return;
                }
                if (me != null || HMR.getState() != State.Closed) {
                    String eMessage = "[P]Duplicate call login, please logout first";
                    if (HMR.getState() == State.Closing) {
                        eMessage = "[P]Please wait close finished";
                    }
                    CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.BAD_USER_ERROR, eMessage));
                    return;
                }
                HummerEngine.addKickOutHandler(KICK_OUT_HANDLER);
                HMR.setHummerState(State.Opening);
                me = new User(uid);
                HMRContext.region = region;
                HMRContext.contextId = hmrCompletion.getRequestId();
                Log.i(HMR.TAG, Trace.method("open").msg("open sdk, do it"));
                ServiceProvider.openServices(new HMRCompletion(hmrCompletion.getRequestId()).onSuccess(new OnSuccess(){

                    @Override
                    public void onSuccess() {
                        Completion completionWrap = new Completion(){

                            @Override
                            public void onSuccess() {
                                HMR.setHummerState(State.Opened);
                                HMRContext.reportReturnCode(funcName, now);
                                CompletionUtils.dispatchSuccess(hmrCompletion);
                            }

                            @Override
                            public void onFailed(Error err) {
                                HMR.doOpenFailed(hmrCompletion, funcName, now, err);
                            }
                        };
                        HummerEngine.login(hmrCompletion.getRequestId(), uid, region, token, completionWrap);
                    }
                }).onFailure(new OnFailure(){

                    @Override
                    public void onFailure(Error error) {
                        HMR.doOpenFailed(hmrCompletion, funcName, now, error);
                    }
                }));
            }
        });
    }

    public static void close(@Nullable Completion completion) {
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        Log.i(TAG, Trace.method("close").msg("user close").info("rid", requestId.getId()));
        final HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        HMRContext.work.async(new Runnable(){

            @Override
            public void run() {
                if (!HMR.isInitialized()) {
                    CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
                    HMRContext.reportReturnCode("HMRClose", now, ErrorEnum.UNINITIALIZED_EXCEPTION.getCode());
                    return;
                }
                HMR.setHummerState(State.Closing);
                me = null;
                HMRContext.region = null;
                HMRContext.contextId = null;
                HummerEngine.removeKickOutHandler(KICK_OUT_HANDLER);
                ServiceProvider.closeServices();
                HummerEngine.logout(hmrCompletion.getRequestId(), new Completion(){

                    @Override
                    public void onSuccess() {
                        HMR.setHummerState(State.Closed);
                        HMRContext.reportReturnCode("HMRClose", now);
                        CompletionUtils.dispatchSuccess(hmrCompletion);
                    }

                    @Override
                    public void onFailed(Error err) {
                        HMR.setHummerState(State.Closed);
                        HMRContext.reportReturnCode("HMRClose", now, err);
                        CompletionUtils.dispatchFailure(hmrCompletion, err);
                    }
                });
            }
        });
    }

    public static <Service> Service getService(@NonNull Class<Service> serviceClass) {
        return ServiceProvider.get(serviceClass);
    }

    public static State getState() {
        HMRContext.reportReturnCode("HMRGetState", HMRContext.getCurrentTime());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStateListener(@NonNull StateListener listener) {
        HMRContext.reportReturnCode("HMRAddStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            CopyOnWriteArraySet<StateListener> copyOnWriteArraySet = mStateListeners;
            synchronized (copyOnWriteArraySet) {
                mStateListeners.add(listener);
            }
            HMR.setHummerState(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStateListener(@NonNull StateListener listener) {
        HMRContext.reportReturnCode("HMRRemoveStateListener", HMRContext.getCurrentTime());
        if (listener != null) {
            CopyOnWriteArraySet<StateListener> copyOnWriteArraySet = mStateListeners;
            synchronized (copyOnWriteArraySet) {
                mStateListeners.remove(listener);
            }
        }
    }

    private static void setHummerState(@Nullable State state) {
        State fromState = HMR.state;
        if (state != null) {
            HMR.state = state;
        }
        HMR.notifyUpdateHummerState(fromState, HMR.state);
    }

    private static void notifyUpdateHummerState(final State fromState, final State toState) {
        DispatchQueue.main.sync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CopyOnWriteArraySet copyOnWriteArraySet = mStateListeners;
                synchronized (copyOnWriteArraySet) {
                    for (StateListener l : mStateListeners) {
                        l.onUpdateHummerState(fromState, toState);
                    }
                }
            }
        });
    }

    public static void addTokenInvalidListener(@NonNull TokenInvalidListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.addTokenInvalidListener(listener);
        HMRContext.reportReturnCode("HMRAddTokenInvalidListener", now);
    }

    public static void removeTokenInvalidListener(@NonNull TokenInvalidListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.removeTokenInvalidListener(listener);
        HMRContext.reportReturnCode("HMRRemoveTokenInvalidListener", now);
    }

    public static void addHummerListener(@NonNull HummerListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.addHummerListener(listener);
        HMRContext.reportReturnCode("HMRAddHummerListener", now);
    }

    public static void removeHummerListener(@NonNull HummerListener listener) {
        long now = HMRContext.getCurrentTime();
        HummerEngine.removeHummerListener(listener);
        HMRContext.reportReturnCode("HMRRemoveHummerListener", now);
    }

    public static ConnectionState getConnectionState() {
        long now = HMRContext.getCurrentTime();
        ConnectionState state = HummerEngine.getConnectionState();
        HMRContext.reportReturnCode("HMRGetConnectionState", now);
        return state;
    }

    public static String getVersion() {
        long now = HMRContext.getCurrentTime();
        String version = HummerEngine.getSdkVersion();
        HMRContext.reportReturnCode("HMRGetVersion", now);
        return version;
    }

    public static User getMe() {
        return me;
    }

    public static boolean isMe(Identifiable identity) {
        return Identifiable.equals(me, identity);
    }

    @Deprecated
    public static void refreshToken(@NonNull String token) {
        final long now = HMRContext.getCurrentTime();
        Completion completion = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshToken", now);
            }

            @Override
            public void onFailed(Error err) {
                HMR.hummerStateToClosed();
                HMRContext.reportReturnCode("HMRRefreshToken", now, err);
            }
        };
        HummerEngine.refreshToken(token, completion);
    }

    @Deprecated
    public static void refreshToken(@NonNull String token, final @Nullable Completion completion) {
        Log.i(TAG, "HMRRefreshTokenWithCompletionrefreshToken: " + token.length());
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshTokenWithCompletion", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMR.hummerStateToClosed();
                HMRContext.reportReturnCode("HMRRefreshTokenWithCompletion", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.refreshToken(token, completionWrap);
    }

    public static void refreshToken1(@NonNull String token, final @Nullable Completion completion) {
        Log.i(TAG, "HMRRefreshToken1refreshToken: " + token.length());
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshToken1", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMRContext.reportReturnCode("HMRRefreshToken1", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.refreshToken1(token, completionWrap);
    }

    public static void refreshToken1(@NonNull byte[] token, final @Nullable Completion completion) {
        Log.i(TAG, "HMRRefreshByteToken1refreshToken: " + token.length);
        final long now = HMRContext.getCurrentTime();
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        HMRCompletion hmrCompletion = new HMRCompletion(requestId, completion);
        if (!HMR.isInitialized()) {
            CompletionUtils.dispatchFailure(hmrCompletion, new Error(ErrorEnum.UNINITIALIZED_EXCEPTION, "The Hummer SDK has not been initialized, please call 'HMR.init' firstly"));
            return;
        }
        Completion completionWrap = new Completion(){

            @Override
            public void onSuccess() {
                HMRContext.reportReturnCode("HMRRefreshByteToken1", now);
                if (completion != null) {
                    completion.onSuccess();
                }
            }

            @Override
            public void onFailed(Error err) {
                HMRContext.reportReturnCode("HMRRefreshByteToken1", now, err);
                if (completion != null) {
                    completion.onFailed(err);
                }
            }
        };
        HummerEngine.refreshToken1(token, completionWrap);
    }

    public static boolean setLoggerFilePath(@NonNull String loggerPath) {
        long now = HMRContext.getCurrentTime();
        if (TextUtils.isEmpty((CharSequence)loggerPath)) {
            Log.e(TAG, Trace.method("setLoggerFilePath").msg("path must be not null").info("path", loggerPath));
            HMRContext.reportReturnCode("HMRSetLoggerFilePath", now, ErrorEnum.INVALID_PARAMETER.getCode());
            return false;
        }
        Log.i(TAG, "setLoggerFilePath: " + loggerPath);
        HummerLog.instance().setLogFilePath(loggerPath);
        HMRContext.reportReturnCode("HMRSetLoggerFilePath", now);
        return true;
    }

    public static boolean setLogLevel(HMRLogLevel logLevel) {
        long now = HMRContext.getCurrentTime();
        if (logLevel == null) {
            Log.e(TAG, Trace.method("setLogLevel").msg("level must be not null"));
            HMRContext.reportReturnCode("HMRSetLogLevel", now, ErrorEnum.INVALID_PARAMETER.getCode());
            return false;
        }
        Log.i(TAG, Trace.method("setLogLevel").info("level", logLevel.getLevel()));
        HummerLog.instance().setLogLevel(logLevel.getLevel());
        HMRContext.reportReturnCode("HMRSetLogLevel", now);
        return true;
    }

    public static boolean uploadLogsManually(String remark) {
        long now = HMRContext.getCurrentTime();
        HummerLog.instance().uploadLog(remark);
        HMRContext.reportReturnCode("HMRUploadLogsManually", now);
        return true;
    }

    public static boolean setLogCallback(HMRLogCallback callback) {
        long now = HMRContext.getCurrentTime();
        HummerLog.instance().setLogCallback(callback);
        HMRContext.reportReturnCode("HMRSetLogCallback", now);
        return true;
    }

    public static TextMessage createTextMessage(String text) {
        return HummerEngine.createTextMessage(text);
    }

    public static void sendP2PMessage(@NonNull User receiver, @NonNull BaseMessage message, P2PMessageOptions options, Completion completion) {
        HummerEngine.sendP2PMessage(receiver, message, options, completion);
    }

    public static void fetchUserOnlineStatus(@NonNull Set<User> users, CompletionArg<Set<UserOnlineStatus>> completion) {
        HummerEngine.fetchUserOnlineStatus(users, completion);
    }

    private static void hummerStateToClosed() {
        me = null;
        HMRContext.region = null;
        HMR.setHummerState(State.Closed);
    }

    public static interface HMRLogCallback {
        public void onHmrLogWithLevel(HMRLogLevel var1, String var2);
    }

    public static enum HMRLogLevel {
        HMR_LOG_LEVEL_VERBOSE(0),
        HMR_LOG_LEVEL_DEBUG(1),
        HMR_LOG_LEVEL_INFO(2),
        HMR_LOG_LEVEL_WARNING(3),
        HMR_LOG_LEVEL_ERROR(4),
        HMR_LOG_LEVEL_RELEASE(10);

        private int level;

        private HMRLogLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public static HMRLogLevel toLevel(int level) {
            for (HMRLogLevel type : HMRLogLevel.values()) {
                if (type.getLevel() != level) continue;
                return type;
            }
            return HMR_LOG_LEVEL_VERBOSE;
        }
    }

    public static interface CompletionArgs<Argument1, Argument2> {
        public void onSuccess(Argument1 var1, Argument2 var2);

        public void onFailed(Error var1);
    }

    public static interface CompletionArg<Argument> {
        public void onSuccess(Argument var1);

        public void onFailed(Error var1);
    }

    public static interface Completion {
        public void onSuccess();

        public void onFailed(Error var1);
    }

    public static interface HummerListener {
        public void onConnectionStateChanged(ConnectionState var1, ConnectionState var2, String var3);

        public void onHummerTokenWillExpired();

        public void onForceoutOffline(int var1, String var2);

        public void onP2PTextMessageReceived(User var1, TextMessage var2);
    }

    public static interface TokenInvalidListener {
        @Deprecated
        public void onHummerTokenInvalid(TokenInvalidCode var1, String var2);

        public void onHummerPreviousTokenExpired();
    }

    public static interface StateListener {
        public void onUpdateHummerState(State var1, State var2);
    }

    public static enum TokenInvalidCode {
        EXPIRED(2003);

        private int code;

        private TokenInvalidCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum ConnectionState {
        Unavailable,
        Disconnected,
        Connecting,
        Reconnecting,
        Connected;

    }

    public static enum State {
        Unavailable,
        Opening,
        Opened,
        Closing,
        Closed;

    }
}

