package com.hummer.im.service;

import androidx.annotation.NonNull;

import com.hummer.im.HMR;
import com.hummer.im.model.id.User;

import java.util.List;

/**
 * 黑名单服务
 */
public interface BlacklistService {

    /**
     * 获取黑名单列表
     *
     * @param completion 回调
     */
    void listBlacklist(HMR.CompletionArg<List<User>> completion);

    /**
     * 用于判定指定用户是否在黑名单
     *
     * @param user       需要判定的用户
     * @param completion 该操作的异步回调
     */
    void isBlocked(@NonNull User user, HMR.CompletionArg<Boolean> completion);

    /**
     * 将同伴加入黑名单
     *
     * @param user       被加入黑名单的同伴
     * @param completion 该操作的异步回调
     */
    void block(@NonNull User user, HMR.Completion completion);

    /**
     * 将指定同伴从黑名单中移除
     *
     * @param user       欲移除的同伴
     * @param completion 该操作的异步回调
     */
    void unblock(@NonNull User user, HMR.Completion completion);

    /**
     * 添加黑名单通知监听器
     *
     * @param listener 监听器
     */
    void addListener(BlacklistListener listener);

    /**
     * 移除黑名单通知监听器
     *
     * @param listener 监听器
     */
    void removeListener(BlacklistListener listener);

    interface BlacklistListener {
        /**
         * 当拉黑了一个用户时，会收到该回调，由本用户发起
         *
         * @param user 被拉黑的用户
         */
        void onBlockUser(@NonNull User user);

        /**
         * 取消拉黑一个用户的回调
         *
         * @param user 被取消拉黑的用户
         */
        void onUnblockUser(@NonNull User user);

        /**
         * 被其他用户拉黑时的回调
         *
         * @param user 拉黑我的用户
         */
        void onBlockedByUser(@NonNull User user);

        /**
         * 被其他用户取消拉黑时的回调
         *
         * @param user 取消拉黑我的用户
         */
        void onUnblockedByUser(@NonNull User user);
    }
}
