package com.hummer.im.model.user;

import com.hummer.im.model.id.User;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户在线状态
 */
public class UserOnlineStatus {
    public enum OnlineStatus {

        /**
         * 未定义
         */
        UNDEFINED(-1),

        /**
         * 离线状态
         */
        OFFLINE(0),

        /**
         * 在线状态
         */
        ONLINE(1),

        /**
         * 断连状态
         */
        DISCONNECTED(2)
        ;

        private int status;

        private static Map<Integer, OnlineStatus> statusMap = new HashMap<>();
        static {
            statusMap.put(UNDEFINED.getStatus(), UNDEFINED);
            statusMap.put(OFFLINE.getStatus(), OFFLINE);
            statusMap.put(ONLINE.getStatus(), ONLINE);
            statusMap.put(DISCONNECTED.getStatus(), DISCONNECTED);
        }

        OnlineStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }

        public static OnlineStatus getOnlineStatus(int status) {
            OnlineStatus onlineStatus = statusMap.get(status);
            return onlineStatus == null ? UNDEFINED : onlineStatus;
        }
    }

    private User user;

    private OnlineStatus status;

    public UserOnlineStatus(User user, OnlineStatus status) {
        this.user = user;
        this.status = status;
    }

    public User getUser() {
        return user;
    }

    public OnlineStatus getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserOnlineStatus that = (UserOnlineStatus) o;

        if (user != null ? !user.equals(that.user) : that.user != null) {
            return false;
        }
        return status == that.status;
    }

    @Override
    public int hashCode() {
        int result = user != null ? user.hashCode() : 0;
        result = 31 * result + (status != null ? status.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "UserOnlineStatus{" +
                "user=" + user +
                ", status=" + status +
                '}';
    }
}
