package com.hummer.im.model.option;

public enum TokenType {

    /**
     * 国际版UDB的service token，使用用yyloginlitesdk 的getServiceToken 接口得到token
     */
    NEW_UDB_TOKEN(0),

    /**
     * 第三方产的service token
     */
    THIRD_USER_TOKEN(1),

    /**
     * YY体系（国内UDB）下的linked token
     */
    YY_UDB_TOKEN(2),

    /**
     * UDB产的随机匿名账号
     */
    YY_COOKIE(3)
    ;

    private final int type;

    TokenType(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }
}
