package com.hummer.im.model.option;

public class HummerOptions {

    /**
     * 是否是委托模式, 默认: 否
     * <br> 委托模式下, 通道的初始化和绑定将都交由业务自己实现
     */
    private boolean isDelegateMode = false;

    /**
     * 默认第三方
     */
    private TokenType tokenType = TokenType.THIRD_USER_TOKEN;

    /**
     * 消息拉取策略
     */
    private FetchStrategy fetchStrategy;

    public boolean getIsDelegateMode() {
        return isDelegateMode;
    }

    public HummerOptions setIsDelegateMode(boolean isDelegateMode) {
        this.isDelegateMode = isDelegateMode;
        return this;
    }

    public TokenType getTokenType() {
        return tokenType;
    }

    public HummerOptions setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public FetchStrategy getFetchStrategy() {
        return fetchStrategy;
    }

    public HummerOptions setFetchStrategy(FetchStrategy fetchStrategy) {
        this.fetchStrategy = fetchStrategy;
        return this;
    }

    @Override
    public String toString() {
        return "HummerOptions{" +
                "isDelegateMode=" + isDelegateMode +
                ", tokenType=" + tokenType +
                ", fetchStrategy=" + fetchStrategy +
                '}';
    }
}
