package com.hummer.im.model.option;

/**
 * 消息拉取策略
 */
public enum FetchStrategy {

    /**
     * 接着此前消费的最后一条消息开始持续地获取消息，以尽可能保证消息的连续性。该策略可以满足绝大
     * 部分应用场景。首次激活时不会获取已经被它端消费过的消息。
     */
    CONTINUOUSLY,

    /**
     * 跳过已被消费的消息
     * <p>
     * 因为某些特殊原因，例如业务服务器强行指定消费起始点，部分消息可能会被标记为已消费。那么
     * 后续处理应该跳过它们。该策略仅在非常少的应用场景中会被使用，目前可能包含：
     * > 用户在多个设备中使用同一账号进行登录，但是业务希望已经被其中一台设备获取过的消息，
     * 在另一端的应用启动时，不再重复获取
     * > 存在两套同时工作，但是数据互通的IM SDK，在它们之间进行切换时，被其中一个SDK所消
     * 费过的消息，不应该再被另一个SDK所获取
     */
    SKIP_FETCHED,

    /**
     * 强行拉取服务器留存的所有消息
     */
    RELOAD_HISTORIES,

    /**
     * 从服务器获取当时最新的seqId，然后从该位置开始拉取
     */
    IGNORE_BEFORE;

    FetchStrategy() {

    }
}
