package com.hummer.im.model.message;

/**
 * 消息可选项
 */
public class P2PMessageOptions {

    /**
     * 消息是否开启支持离线功能，默认关闭
     */
    private boolean isOffline = false;

    public boolean getOffline() {
        return isOffline;
    }

    public P2PMessageOptions setOffline(boolean offline) {
        isOffline = offline;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        P2PMessageOptions that = (P2PMessageOptions) o;

        return isOffline == that.isOffline;
    }

    @Override
    public int hashCode() {
        return (isOffline ? 1 : 0);
    }

    @Override
    public String toString() {
        return "P2PMessageOptions{" +
                "isOffline=" + isOffline +
                '}';
    }
}
