package com.hummer.im.model.message;

import java.util.Map;

/**
 * 消息基类
 */
public abstract class BaseMessage {

    /**
     * 获取消息唯一标识 uuid
     * @return uuid
     */
    public abstract String getUuid();

    /**
     * 获取消息类型
     * @return {@link MessageType}
     */
    public abstract MessageType getMessageType();

    /**
     * 获取消息时间戳
     * @return  timestamp
     */
    public abstract long getTimestamp();

    /**
     * 获取消息扩展信息
     * @return Map
     */
    public abstract Map<String, String> getExtra();

    /**
     * 设置扩展信息
     * @param extra 扩展信息
     */
    public abstract void setExtra(Map<String, String> extra);
}
