package com.hummer.im.model.id;

import java.util.Iterator;
import java.util.Map;

public class UserInfo {

    private User user;
    private Map<String, String> properties;

    public UserInfo(User user, Map<String, String> properties) {
        this.user = user;
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static boolean compare(UserInfo lui, UserInfo rui) {
        if (!lui.getUser().equals(rui.getUser())) {
            return false;
        }

        Map<String, String> lp = lui.getProperties();
        Map<String, String> rp = rui.getProperties();

        Iterator<Map.Entry<String, String>> liter = lp.entrySet().iterator();
        while (liter.hasNext()) {
            Map.Entry<String, String> lentry = liter.next();
            String lvalue = lentry.getValue() == null ? "" : lentry.getValue();
            String rvalue = rp.get(lentry.getKey()) == null ? "" : rp.get(lentry.getKey());

            if (!lvalue.equals(rvalue)) {
                return false;
            }
        }

        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UserInfo)) {
            return false;
        }

        if (!this.getUser().equals(((UserInfo) obj).getUser())) {
            return false;
        }

        return true;
    }
}
