package com.hummer.im.model.id;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;

/**
 * 用于标识Hummer系统的一个用户对象标识
 */
public final class User extends Identifiable {

    /**
     * 构造用户标识对象
     * @param uid 用户uid
     */
    public User(long uid) {
        this.uid = uid;
    }

    /**
     * 获取用户标识的id数值
     */
    @Override
    public long getId() {
        return uid;
    }

    @Override
    public boolean valid() {
        return uid >= 1 && uid <= Long.MAX_VALUE - 1;
    }

    @Override
    public String toString() {
        return "User{" + getId() + "}";
    }

    @Override
    public int hashCode() {
        return Long.valueOf(uid).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof User)) {
            return false;
        }

        User user = (User) o;
        return uid == user.uid;
    }

    private final long uid;
}
