package com.hummer.im.model.id;

/**
 * Identifiable 用于标识消息的关系者，一般用于消息发送方、接收方
 *
 * <br> 可能存在的类型如：
 * <br> {@link User}   表示消息发送/接收方为用户
 * <br> 在具体使用时，应通过RTTI机制进行具体类型判别
 */
public abstract class Identifiable {

    /**
     * 无论是User，还是Group，都必须具备唯一标识符，getId用于返回该标识符。但是User和Group可能会拥有
     * 相同的id值。因此，必须谨记，无法通过id值的特征来判断不同的消息sender, receiver。
     */
    public abstract long getId();

    public abstract boolean valid();

    /**
     * 判断两个Identifiable是否语义相等
     *
     * @return 如果两者是类型兼容的，而且id相等，则返回true，否则返回false
     */
    public static boolean equals(Identifiable lhs, Identifiable rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }

        if (lhs == rhs) {
            return true;
        }

        if (rhs.getClass().isAssignableFrom(lhs.getClass()) || lhs.getClass().isAssignableFrom(rhs.getClass())) {
            return lhs.getId() == rhs.getId();
        }

        return false;
    }
}
