package com.hummer.im.model.id;

public final class Group extends Identifiable {

    public Group(long groupId) {
        this.id = groupId;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group) o;
        return id == group.id;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(id).hashCode();
    }

    @Override
    public String toString() {
        return "Group{" + id + '}';
    }

    private final long id;
}
