package com.hummer.im.model.id;

public class AppSession extends Identifiable {

    private final long id;
    private final String type;
    private final String region;

    public AppSession(String type, long id, String region) {
        this.type = type;
        this.id = id;
        this.region = region;
    }

    public String getType() {
        return type;
    }

    public String getRegion() {
        return region;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public String toString() {
        return "AppSession{" + id + ", " + type + ", " + region + '}';
    }

    @Override
    public int hashCode() {
        return Long.valueOf(id).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof AppSession)) {
            return false;
        }

        AppSession appSession = (AppSession) o;

        boolean isEqual = id == appSession.id && type.equals(appSession.type);

        if (region != null && appSession.region != null) {
            isEqual = region.equals(appSession.region);
        }

        return isEqual;
    }
}
