package com.hummer.im.model.chat.store;

import com.hummer.im.model.chat.Message;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 消息移除的条件描述
 */
@SuppressWarnings({"unused"})
public final class RemovingClauses {
    /**
     * 欲移除的消息列表
     */
    public List<Message> messages = new ArrayList<>();

    public Set<String> uuids = new HashSet<>();

    /**
     * 指定移除特定的消息
     * @param one 欲移除的消息对象
     */
    public RemovingClauses setOne(Message one) {
        messages = new ArrayList<>();
        messages.add(one);
        return this;
    }

    public RemovingClauses setOne(String uuid) {
        uuids = new HashSet<>();
        uuids.add(uuid);
        return this;
    }

    /**
     * 移除多个指定的消息
     *
     * @param someMsg 欲移除的消息列表
     */
    public RemovingClauses setSome(Set<Message> someMsg) {
        messages = new ArrayList<>(someMsg);
        return this;
    }

    public RemovingClauses setSomeUuids(Set<String> someUuids) {
        uuids = new HashSet<>(someUuids);
        return this;
    }

    /**
     * 移除会话内所有的消息，即清空会话
     */
    public RemovingClauses setClearAll() {
        messages = null;
        uuids = null;
        return this;
    }

    @Override
    public String toString() {
        String string = "RemovingClauses{";

        if (messages == null && uuids == null) {
            string += "All";
        } else if ((messages.size() + uuids.size()) == 1) {
            string += "One";
        } else {
            string += "Some";
        }

        return string;
    }
}
