package com.hummer.im.model.chat.store;

import android.text.TextUtils;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;

import org.json.JSONException;
import org.json.JSONObject;

public class MessageStoreStrategy {

    /**
     * 是否作为历史消息进入远端历史消息队列，进入队列后，业务可以通过远端历史消息接口拉取该消息，默认为 false;
     */
    private boolean isRemoteHistoryMessage = false;

    /**
     * 是否作为历史消息加入本地历史消息存储系统，业务可以通过本地历史消息接口拉取该消息，默认为 true;
     */
    private boolean isLocalHistoryMessage = true;

    /**
     * 是否能作为会话的最后一条消息，本地存储系统根据该属性决定是否能作为最后一条消息，默认为 true;
     */
    private boolean isLastMessage = true;

    /**
     * 是否能计入会话的未读消息数，默认为 true;
     */
    private boolean isUnreadCount = true;

    public MessageStoreStrategy() {

    }

    public MessageStoreStrategy(boolean isRemoteHistoryMessage,
                                boolean isLocalHistoryMessage,
                                boolean isLastMessage,
                                boolean isUnreadCount) {
        this.isRemoteHistoryMessage = isRemoteHistoryMessage;
        this.isLocalHistoryMessage = isLocalHistoryMessage;
        this.isLastMessage = isLastMessage;
        this.isUnreadCount = isUnreadCount;
    }

    public boolean isRemoteHistoryMessage() {
        return isRemoteHistoryMessage;
    }

    public MessageStoreStrategy setRemoteHistoryMessage(boolean remoteHistoryMessage) {
        isRemoteHistoryMessage = remoteHistoryMessage;
        return this;
    }

    public boolean isLocalHistoryMessage() {
        return isLocalHistoryMessage;
    }

    public MessageStoreStrategy setLocalHistoryMessage(boolean localHistoryMessage) {
        isLocalHistoryMessage = localHistoryMessage;
        return this;
    }

    public boolean isLastMessage() {
        return isLastMessage;
    }

    public MessageStoreStrategy setLastMessage(boolean lastMessage) {
        isLastMessage = lastMessage;
        return this;
    }

    public boolean isUnreadCount() {
        return isUnreadCount;
    }

    public MessageStoreStrategy setUnreadCount(boolean unreadCount) {
        isUnreadCount = unreadCount;
        return this;
    }

    public static String makeString(MessageStoreStrategy storeStrategy) {
        if (storeStrategy == null) {
            return "";
        }

        JSONObject json = new JSONObject();
        try {
            json.put(FIELD_IS_REMOTE_HISTORY_MESSAGE, storeStrategy.isRemoteHistoryMessage());
            json.put(FIELD_IS_LOCAL_HISTORY_MESSAGE, storeStrategy.isLocalHistoryMessage());
            json.put(FIELD_IS_LAST_MESSAGE, storeStrategy.isLastMessage());
            json.put(FIELD_IS_UNREAD_COUNT, storeStrategy.isUnreadCount());

            return json.toString();
        } catch (JSONException e) {
            Log.e(TAG, Trace.method("makeString").info("store strategy to json error", e.getMessage()));
            return "";
        }
    }

    public static MessageStoreStrategy makeContent(String jsonStr) {
        if (TextUtils.isEmpty(jsonStr)) {
            return null;
        }

        try {
            JSONObject json = new JSONObject(jsonStr);

            return new MessageStoreStrategy(json.getBoolean(FIELD_IS_REMOTE_HISTORY_MESSAGE),
                    json.getBoolean(FIELD_IS_LOCAL_HISTORY_MESSAGE),
                    json.getBoolean(FIELD_IS_LAST_MESSAGE),
                    json.getBoolean(FIELD_IS_UNREAD_COUNT));
        } catch (JSONException e) {
            Log.e(TAG, Trace.method("makeContent").info("json to store strategy error", e.getMessage()));
            return null;
        }
    }

    @Override
    public String toString() {
        return "MessageStoreStrategy{" +
                "isRemoteHistoryMessage=" + isRemoteHistoryMessage +
                ", isLocalHistoryMessage=" + isLocalHistoryMessage +
                ", isLastMessage=" + isLastMessage +
                ", isUnreadCount=" + isUnreadCount +
                '}';
    }

    private static final String FIELD_IS_REMOTE_HISTORY_MESSAGE = "isRemoteHistoryMessage";
    private static final String FIELD_IS_LOCAL_HISTORY_MESSAGE = "isLocalHistoryMessage";
    private static final String FIELD_IS_LAST_MESSAGE = "isLastMessage";
    private static final String FIELD_IS_UNREAD_COUNT = "isUnreadCount";

    private static final String TAG = "MessageStoreStrategy";
}
