package com.hummer.im.model.chat.states;


import androidx.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.model.chat.Message;
import com.hummer.im.service.ChatService;

/**
 * Failed状态只在发送流程中会出现，一般在content处理失败，或者是RPC投递过程中发生了网络、服务器异常时
 * 会成为Failed状态，具体的失败原因，请查看其error属性
 */
public final class Failed implements Message.State {
    /**
     * 失败状态所携带的错误上下文
     */
    public final @NonNull
    Error error;

    /**
     * 构造一个StateFailed状态实例，通常是在{@link ChatService#send}
     * 方法中实例化的，因为只有该方法会产生失败状态。
     *
     * @param err 携带错误上下文信息的Error实例对象
     */
    public Failed(@NonNull Error err) {
        this.error = err;
    }

    @Override
    public String toString() {
        return "[Failed: " + error + "]";
    }

}
