package com.hummer.im.model.chat.contents;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.model.chat.CodecManager;
import com.hummer.im.model.chat.Content;

import java.nio.charset.Charset;

/**
 * Hummer内置的文本消息内容类型
 */
public final class Text extends Content {

    public static final int TYPE = 0;

    /**
     * 构造一个文本消息
     * @param text 消息的文本内容
     */
    public Text(String text) {
        this.text = text;
    }

    /**
     * 获取消息的文本
     */
    public String getText() {
        return text;
    }

    @Override
    public Error validContent() {
        if (text != null && text.getBytes(Charset.forName("UTF-8")).length > 32 * 1024) {
            return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
        }
        return null;
    }

    @Override
    public String toString() {
        return "Text{" + getText() + "}";
    }

    /**
     * 注册文本消息的编码、解码器
     */
    public static void registerCodecs() {
        registerCodec(new Codec() {
            @Override
            public int type() {
                return TYPE;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Text.class;
            }

            @Override
            public Content makeChatContent(String data) {
                return new Text(data);
            }

            @Override
            public String makeDBString(Content content) {
                if (!(content instanceof Text)) {
                    Log.e("Text", Trace.method("makeDBString")
                            .info("content", content));
                    return null;
                }
                return ((Text) content).getText();
            }

            @Override
            public String toString() {
                return "TextCodec";
            }
        });
    }

    private final String text;
}
