package com.hummer.im.model.chat.contents;

import android.util.Base64;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im.model.chat.AppContent;
import com.hummer.im.model.chat.Content;

import org.json.JSONObject;

public class CustomContent extends Content {

    public static final int TYPE = 5;

    private final byte[] data;

    public CustomContent(byte[] data) {
        this.data = data;
    }

    @Override
    public Error validContent() {
        if (data != null && data.length > 32 * 1024) {
            return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
        }

        return null;
    }

    public byte[] getData() {
        return data;
    }

    @Override
    public String toString() {
        return "CustomContent{" +
                "data.size=" + data.length+
                '}';
    }

    public static void registerCodecs() {
        registerCodec(new Codec() {
            @Override
            public int type() {
                return TYPE;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return CustomContent.class;
            }

            @Override
            public String makeDBString(Content content) throws Throwable {
                return Base64.encodeToString(((CustomContent) content).getData(), Base64.DEFAULT);
            }

            @Override
            public Content makeChatContent(String data) throws Throwable {
                return new CustomContent(Base64.decode(data, Base64.DEFAULT));
            }

            @Override
            public String toString() {
                return "CustomContent";
            }
        });
    }
}
