package com.hummer.im.model.chat;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.LinkedList;
import java.util.List;

@SuppressWarnings("unused")
public final class StringChain {

    public StringChain setName(@NonNull String name) {
        this.name = name;
        return this;
    }

    public StringChain setConnector(@NonNull String connector) {
        this.connector = connector;
        return this;
    }

    public StringChain setDelimiter(@NonNull String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public StringChain acceptNullElements() {
        this.acceptNullElements = true;
        return this;
    }

    public StringChain add(@NonNull String lhs, @Nullable Object rhs) {
        if (rhs != null || acceptNullElements) {
            elements.add(lhs + connector + rhs);
        }

        return this;
    }

    @Override
    public String toString() {
        String string = TextUtils.join(delimiter, elements);

        if (name != null) {
            string = name + '{' + string + '}';
        }

        return string;
    }

    private boolean acceptNullElements = false;
    private String name      = null;
    private String connector = ":";
    private String delimiter = ", ";

    private List<String> elements = new LinkedList<>();
}
