package com.hummer.im.model.chat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodecManager<DataType, DataValue, Model> {

    private static final String TAG = "CodecManager";

    public interface Codec<DataType, DataValue, Model> {
        DataType getDataType();

        Class<? extends Model> getModelClass();

        Model decode(DataValue data) throws Throwable;

        DataValue encode(Model model) throws Throwable;
    }

    public void register(Codec<DataType, DataValue, Model> codec) {
        DataType key = codec.getDataType();
        type2codec.put(key, codec);

        Class<? extends Model> clazz = codec.getModelClass();
        clazz2codec.put(clazz, codec);
    }

    public DataType getDataType(Model model) {
        Class clazz = model.getClass();
        Codec<DataType, DataValue, Model> codec = clazz2codec.get(clazz);
        if (codec == null) {
//            Log.e(TAG, Trace.method("getDataType").msg("codec is null")
//                    .info("model", model)
//                    .info("clazz", clazz)
//                    .info("clazz2codec", clazz2codec));
            return null;
        }

        try {
            return codec.getDataType();
        } catch (Throwable t) {
//            Log.e(TAG, Trace.method("encode").msg("Exception")
//                    .info("model", model)
//                    .info("clazz", clazz)
//                    .info("error", t.getMessage()));
            return null;
        }
    }

    public DataValue encode(Model model) {
        Class clazz = model.getClass();
        Codec<DataType, DataValue, Model> codec = clazz2codec.get(clazz);
        if (codec == null) {
//            Log.e(TAG, Trace.method("encode").msg("codec is null")
//                    .info("model", model)
//                    .info("clazz", clazz)
//                    .info("clazz2codec", clazz2codec));
            return null;
        }

        try {
            return codec.encode(model);
        } catch (Throwable t) {
//            Log.e(TAG, Trace.method("encode").msg("Exception")
//                    .info("model", model)
//                    .info("clazz", clazz)
//                    .info("error", t.getMessage()));
            return null;
        }
    }

    public Model decode(DataType type, DataValue data) {
        Codec<DataType, DataValue, Model> codec = type2codec.get(type);

        if (codec == null) {
//            Log.e(TAG, Trace.method("decode").msg("codec is null")
//                    .info("type", type)
//                    .info("data", data)
//                    .info("type2codec", type2codec.toString()));
            return null;
        }

        // 注意，即使有codec，也并不意味着一定会创建成功。如果反序列化失败，则依然可能返回null对象
        try {
            return codec.decode(data);
        } catch (Throwable t) {
//            Log.e(TAG, Trace.method("decode").msg("Exception")
//                    .info("type", type)
//                    .info("data", data)
//                    .info("error", t.getMessage()));
            return null;
        }
    }

    public boolean isNotExistCodec(DataType type) {
        return type2codec.get(type) == null;
    }

    private final Map<DataType, Codec<DataType, DataValue, Model>> type2codec
            = new ConcurrentHashMap<>();
    private final Map<Class<? extends Model>, Codec<DataType, DataValue, Model>> clazz2codec
            = new ConcurrentHashMap<>();
}