package com.hummer.im.model.chat;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;

public final class AppContent extends Content {

    /**
     * 消息类型
     */
    private int type;

    /**
     * 消息内容
     */
    private byte[] data;

    public AppContent(int type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public Error validContent() {
        if (data != null && data.length > 32 * 1024) {
            return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public byte[] getData() {
        return data;
    }

    @Override
    public String toString() {
        return "AppContent{" +
                "type=" + type +
                '}';
    }
}
