package com.hummer.im.model;

import android.os.Build;

import java.util.Objects;

/**
 * requestId 实体
 *
 * @author Hummer 组
 */
public class RequestId {
    private final long id;

    private final long currentTimeMillis;

    public RequestId(long id) {
        this.id = id;
        this.currentTimeMillis = System.currentTimeMillis();
    }

    public long getId() {
        return id;
    }

    public long getCurrentTimeMillis() {
        return currentTimeMillis;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RequestId requestId = (RequestId) o;
        return id == requestId.id;
    }

    @Override
    public int hashCode() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            return Objects.hash(id);
        }

        return (int) id;
    }

    @Override
    public String toString() {
        return getId() + "";
    }
}
