package com.hummer.im._internals.utility;

import android.content.Context;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.bridge.helper.HummerEngine;
import com.hummer.im._internals.bridge.helper.HummerNative;
import com.hummer.im.model.RequestId;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HMRContext {

    public static final DispatchQueue work = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_core"));
    public static final DispatchQueue reportQueue = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_report"));
    public static Long appId;
    public static RequestId contextId;
    public static String region;
    public static WeakReference<Context> appContext;

    /**
     * 获取Hummer初始化时传入的AppContext实例，该
     *
     * @return 如果Hummer已经正确初始化，则会返回
     */
    public static Context getAppContext() {
        return appContext.get();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static boolean isCurrentContext(RequestId rid) {
        return contextId != null && contextId.equals(rid);
    }

    public static void reportReturnCode(final String function, final long beginTime, final int code) {
        final long rtt = System.currentTimeMillis() - beginTime;
        reportQueue.async(new Runnable() {
            @Override
            public void run() {
                HummerEngine.getInstance().reportReturnCode(function, rtt, code);
            }
        });
    }

    public static void reportReturnCode(final String function) {
        reportReturnCode(function, System.currentTimeMillis());
    }

    public static void reportReturnCode(final String function, final long beginTime) {
        reportReturnCode(function, beginTime, ErrorEnum.OK.getCode());
    }

    public static void reportReturnCode(final String function, final long beginTime, Error error) {
        if (error != null) {
            reportReturnCode(function, beginTime, error.code);
        }
    }

    public static void report(String functionName, long requestId, int code) {
        RequestId request = REQUEST_ID_MAP.remove(requestId);
        if (request != null) {
            reportReturnCode(functionName, request.getCurrentTimeMillis(), code);
        }
    }

    public static RequestId createRequestId() {
        RequestId requestId = new RequestId(RequestIdBuilder.generateRequestId());
        REQUEST_ID_MAP.put(requestId.getId(), requestId);
        return requestId;
    }

    public static final String AREA_CN = "cn";
    public static final String UTF8 = "UTF-8";
    public static final String INVALID_UID = "Invalid Uid";
    public static final String INVALID_OPERATED_UID = "Invalid Operated Uid";
    private static final Map<Long, RequestId> REQUEST_ID_MAP = new ConcurrentHashMap<>();
}
