package com.hummer.im._internals.message;

import com.hummer.im.model.message.MessageType;
import com.hummer.im.model.message.TextMessage;

import java.util.Map;

public class TextMessageImpl extends TextMessage {

    /**
     * 消息的唯一标识字符串
     */
    private String uuid;

    /**
     * 消息类型
     */
    private MessageType messageType;

    /**
     * 发送时间戳（服务器时间戳）
     */
    private long timestamp;

    /**
     * 附加信息，可以通过该字段进行附带一些信息进行透传
     */
    private Map<String, String> extra;

    /**
     * 文本消息
     */
    private String text;

    public TextMessageImpl(String uuid, long timestamp, String text) {
        this.messageType = MessageType.TEXT;
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.text = text;
    }

    /**
     * 设置
     * @param extra
     */
    @Override
    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    @Override
    public String getText() {
        return text;
    }

    @Override
    public String getUuid() {
        return uuid;
    }

    @Override
    public MessageType getMessageType() {
        return messageType;
    }

    @Override
    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public Map<String, String> getExtra() {
        return extra;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TextMessageImpl that = (TextMessageImpl) o;

        return uuid != null ? uuid.equals(that.uuid) : that.uuid == null;
    }

    @Override
    public int hashCode() {
        return uuid != null ? uuid.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "TextMessageImpl{" +
                "uuid='" + uuid + '\'' +
                ", messageType=" + messageType +
                ", timestamp=" + timestamp +
                ", extra=" + extra +
                ", text='" + text + '\'' +
                '}';
    }
}
