package com.hummer.im._internals.log;

import com.hummer.im.HMR;
import com.hummer.im._internals.bridge.helper.HummerNative;

public class HummerLog implements Log.Logger {

    public static final int LOG_LEVEL_VERBOSE = 0;
    public static final int LOG_LEVEL_DEBUG = 1;
    public static final int LOG_LEVEL_INFO = 2;
    public static final int LOG_LEVEL_WARN = 3;
    public static final int LOG_LEVEL_ERROR = 4;
    public static final int LOG_LEVEL_RELEASE = 10;

    private static volatile HummerLog instance;
    private final static Object SYNC_LOCK = new Object();
    private final static Object SYNC_LOG_CALLBACK = new Object();


    public static HummerLog instance() {
        if (instance == null) {
            synchronized (SYNC_LOCK) {
                if (instance == null) {
                    instance = new HummerLog("Hummer");
                }
            }
        }
        return instance;
    }

    private  HummerLog(String module) {
        this.module = module;
    }

    public void setLogLevel(int level) {
        sLogLevel = level;
        HummerNative.setLogLevel(level);
    }

    @Override
    public void log(int lv, String msg) {
        switch (lv) {
            case LOG_LEVEL_INFO:
                putLog(LOG_LEVEL_INFO, 0, module.getBytes(), null, null, 0, msg.getBytes());
                break;
            case LOG_LEVEL_ERROR:
                putLog(LOG_LEVEL_ERROR, 0, module.getBytes(), null, null, 0, msg.getBytes());
                break;
            case LOG_LEVEL_WARN:
                putLog(LOG_LEVEL_WARN, 0, module.getBytes(), null, null, 0, msg.getBytes());
                break;
            case LOG_LEVEL_DEBUG:
                putLog(LOG_LEVEL_DEBUG, 0, module.getBytes(), null, null, 0, msg.getBytes());
                break;
            case LOG_LEVEL_RELEASE:
                putLog(LOG_LEVEL_RELEASE, 0, module.getBytes(), null, null, 0, msg.getBytes());
                break;
            case LOG_LEVEL_VERBOSE:
                putLog(LOG_LEVEL_VERBOSE, 0, module.getBytes(), null, null, 0, msg.getBytes());
            default:
                break;
        }
    }

    public void enableConsoleLogger(boolean bEnable) {
        Log.d(TAG, "enableConsoleLogger, bEnable " + bEnable);
        HummerNative.disableLogConsole(!bEnable);
    }

    public long setLogFilePath(String filePath) {
        return HummerNative.setLogFilePath(filePath);
    }

    public static void putLog(int level, int module, byte[] moduleName, byte[] tag, byte[] methodName, int line, byte[] msg) {
        if(level < sLogLevel) {
            return;
        }
        if(msg == null || msg.length <= 0) {
            return;
        }
        if (moduleName == null) {
            moduleName = "Hummer".getBytes();
        }
        if (tag == null) {
            tag = TAG.getBytes();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (methodName != null && methodName.length > 0) {
            stringBuilder.append("[").append(new String(methodName)).append("]");
        }
        stringBuilder.append(line);
        stringBuilder.append(new String(msg));
        HummerNative.logText(level, module, new String(moduleName), new String(tag), stringBuilder.toString());
    }


    public void uploadLog(String note) {
        HummerNative.uploadLog(note);
    }

    public void setLogCallback(HMR.HMRLogCallback callback) {
        synchronized (SYNC_LOG_CALLBACK) {
            mLogCallback = callback;
            if(callback != null) {
                HummerNative.setLogCallback(true);
            } else {
                HummerNative.setLogCallback(false);
            }
        }

    }

    public void logCallback(int level, String msg) {
        synchronized (SYNC_LOG_CALLBACK) {
            if (mLogCallback != null) {
                mLogCallback.onHmrLogWithLevel(HMR.HMRLogLevel.toLevel(level), msg);
            }
        }
    }

    private static final String TAG = "HummerLog";
    /** 默认 verbose 级别 */
    private static int sLogLevel = LOG_LEVEL_VERBOSE;
    private final String module;
    private static HMR.HMRLogCallback mLogCallback;


}
