package com.hummer.im._internals.bridge.marshall;

import java.util.concurrent.atomic.AtomicReference;

/**
 * Created by xiaojun on 2017/11/22.
 * Copyright (c) 2017 YY Inc. All rights reserved.
 */

public class NativeByteBufferPool {
    public static AtomicReference<IByteBufferPool> mNativeByteBufferPool = new AtomicReference<IByteBufferPool>
            (null);

    //写加锁.
    public synchronized static void release() {
        if (mNativeByteBufferPool.get() != null) {
            mNativeByteBufferPool.get().clear();
            mNativeByteBufferPool.set(null);
        }
    }

    public synchronized static void alloc() {
        if (mNativeByteBufferPool.get() == null) {
            mNativeByteBufferPool.set(new MshByteBufferPool());
        }
    }

    public static IByteBufferPool get() {
        return mNativeByteBufferPool.get();
    }

}
