package com.hummer.im._internals.bridge.marshall;

//import com.thunder.livesdk.log.ThunderLog;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MshBuffer implements IMshBuffer {
    public ByteBuffer mByteBuffer = null;
    public IByteBufferPool mBytePool = null;

    public MshBuffer(int size, IByteBufferPool pool) {
        mBytePool = pool;
        if (pool == null) {
            mByteBuffer = ByteBuffer.allocate(size);
            mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            mByteBuffer = pool.newBuffer(size);
        }
    }

    @Override
    public void freeBuffer() {
        // TODO Auto-generated method stub
        if (mBytePool != null) {
            mBytePool.freeBuffer(mByteBuffer);
            mByteBuffer = null;
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        // TODO Auto-generated method stub
        return mByteBuffer;
    }

    @Override
    public int increase_capacity(int minIncrement) {
        // TODO Auto-generated method stub
        int capacity = mByteBuffer.capacity();

        if (capacity == 0) {
            return 0;
        }

        int size = 2 * capacity;
        if (minIncrement > capacity) {
            size = capacity + minIncrement;
        }

        ByteBuffer tempBuf;
        if (mBytePool == null) {
            tempBuf = ByteBuffer.allocate(size);
            tempBuf.order(ByteOrder.LITTLE_ENDIAN);
            mByteBuffer.limit(mByteBuffer.position());
            mByteBuffer.position(0);
            tempBuf.put(mByteBuffer);
            mByteBuffer = tempBuf;
        } else {
            tempBuf = mBytePool.newBuffer(size);
            mByteBuffer.limit(mByteBuffer.position());
            mByteBuffer.position(0);
            tempBuf.put(mByteBuffer);

            mBytePool.freeBuffer(mByteBuffer);
            mByteBuffer = tempBuf;
            // TODO
//            ThunderLog.info(ThunderLog.kLogTagSdk, "===MshPoolBuffer, capactiy=" +
//                    mByteBuffer.capacity() + " postion=" + mByteBuffer.position());
        }

        return size;
    }

    @Override
    public void wrap(byte[] buffer) {
        // TODO Auto-generated method stub

        if (mByteBuffer != null && mBytePool != null) {
            mBytePool.freeBuffer(mByteBuffer);
        }

        mByteBuffer = ByteBuffer.wrap(buffer);
        mByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        mBytePool = null;
    }
}
