package com.hummer.im._internals.bridge.helper;

import com.hummer.im._internals.bridge.helper.HummerNotification.NotifyBase;
import com.hummer.im.model.id.User;

import java.util.ArrayList;
import java.util.List;

public class BlacklistNotification {

    public static final int CALLBACK_ON_LIST_BLACKLIST = 901;
    public static final int CALLBACK_ON_IS_USER_BLOCKED = 902;
    public static final int CALLBACK_ON_BLOCK_USER = 903;
    public static final int CALLBACK_ON_UNBLOCK_USER = 904;

    public static final int NOTIFY_ON_BLOCK_USER = 961;
    public static final int NOTIFY_ON_UNBLOCK_USER = 962;
    public static final int NOTIFY_ON_BLOCKED_BY_USER = 963;
    public static final int NOTIFY_ON_UNBLOCKED_BY_USER = 964;

    public static class OnListBlacklist extends HummerNotification.BaseCallback {
        private final List<User> users;

        public OnListBlacklist(long requestId, int code, String desc, List<User> users){
            super(requestId, code, desc);
            this.users = users;
        }

        public List<User> getUsers() {
            return users;
        }
    }

    public static class CallbackOnListBlacklist extends NotifyBase<OnListBlacklist> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = popInt64();
            int code = popInt();
            String desc = popString16UTF8();
            List<User> users = new ArrayList<>();
            int size = popInt();
            for (int i = 0; i < size; i++) {
                users.add(new User(popInt64()));
            }

            setNotification(new OnListBlacklist(requestId, code, desc , users));
        }
    }

    public static class OnIsUserBlocked extends HummerNotification.BaseCallback {
        private final User user;
        private final boolean isBlock;

        public OnIsUserBlocked(long requestId, int code, String desc, User user, boolean isBlock){
            super(requestId, code, desc);
            this.user = user;
            this.isBlock = isBlock;
        }

        public User getUser() {
            return user;
        }

        public boolean getIsBlock() {
            return isBlock;
        }
    }

    public static class CallbackOnIsUserBlocked extends NotifyBase<OnIsUserBlocked> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            long requestId = popInt64();
            int code = popInt();
            String desc = popString16UTF8();
            User user = new User(popInt64());
            boolean isBlock = popBool();

            setNotification(new OnIsUserBlocked(requestId, code, desc , user , isBlock));
        }
    }

    public static class OnBlockUser {
        private final User user;

        public OnBlockUser(User user){
            this.user = user;
        }

        public User getUser() {
            return user;
        }
    }

    public static class NotifyOnBlockUser extends NotifyBase<OnBlockUser> {
        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            User user = new User(popInt64());

            setNotification(new OnBlockUser(user));
        }
    }
}
